/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAssetSourceRequest
extends BmcRequest<Void> {
    private String assetSourceId;
    private String opcRequestId;

    public String getAssetSourceId() {
        return this.assetSourceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().assetSourceId(this.assetSourceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",assetSourceId=").append(String.valueOf(this.assetSourceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAssetSourceRequest)) {
            return false;
        }
        GetAssetSourceRequest other = (GetAssetSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.assetSourceId, other.assetSourceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.assetSourceId == null ? 43 : this.assetSourceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAssetSourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String assetSourceId = null;
        private String opcRequestId = null;

        public Builder assetSourceId(String assetSourceId) {
            this.assetSourceId = assetSourceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAssetSourceRequest o) {
            this.assetSourceId(o.getAssetSourceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAssetSourceRequest build() {
            GetAssetSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAssetSourceRequest buildWithoutInvocationCallback() {
            GetAssetSourceRequest request = new GetAssetSourceRequest();
            request.assetSourceId = this.assetSourceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

