/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hypervisorVendor")
    private final String hypervisorVendor;
    @JsonProperty(value="hypervisorVersion")
    private final String hypervisorVersion;
    @JsonProperty(value="hypervisorHost")
    private final String hypervisorHost;

    @Deprecated
    @ConstructorProperties(value={"hypervisorVendor", "hypervisorVersion", "hypervisorHost"})
    public VmProperties(String hypervisorVendor, String hypervisorVersion, String hypervisorHost) {
        this.hypervisorVendor = hypervisorVendor;
        this.hypervisorVersion = hypervisorVersion;
        this.hypervisorHost = hypervisorHost;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHypervisorVendor() {
        return this.hypervisorVendor;
    }

    public String getHypervisorVersion() {
        return this.hypervisorVersion;
    }

    public String getHypervisorHost() {
        return this.hypervisorHost;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmProperties(");
        sb.append("super=").append(super.toString());
        sb.append("hypervisorVendor=").append(String.valueOf(this.hypervisorVendor));
        sb.append(", hypervisorVersion=").append(String.valueOf(this.hypervisorVersion));
        sb.append(", hypervisorHost=").append(String.valueOf(this.hypervisorHost));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmProperties)) {
            return false;
        }
        VmProperties other = (VmProperties)((Object)o);
        return Objects.equals(this.hypervisorVendor, other.hypervisorVendor) && Objects.equals(this.hypervisorVersion, other.hypervisorVersion) && Objects.equals(this.hypervisorHost, other.hypervisorHost) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hypervisorVendor == null ? 43 : this.hypervisorVendor.hashCode());
        result = result * 59 + (this.hypervisorVersion == null ? 43 : this.hypervisorVersion.hashCode());
        result = result * 59 + (this.hypervisorHost == null ? 43 : this.hypervisorHost.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hypervisorVendor")
        private String hypervisorVendor;
        @JsonProperty(value="hypervisorVersion")
        private String hypervisorVersion;
        @JsonProperty(value="hypervisorHost")
        private String hypervisorHost;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hypervisorVendor(String hypervisorVendor) {
            this.hypervisorVendor = hypervisorVendor;
            this.__explicitlySet__.add("hypervisorVendor");
            return this;
        }

        public Builder hypervisorVersion(String hypervisorVersion) {
            this.hypervisorVersion = hypervisorVersion;
            this.__explicitlySet__.add("hypervisorVersion");
            return this;
        }

        public Builder hypervisorHost(String hypervisorHost) {
            this.hypervisorHost = hypervisorHost;
            this.__explicitlySet__.add("hypervisorHost");
            return this;
        }

        public VmProperties build() {
            VmProperties model = new VmProperties(this.hypervisorVendor, this.hypervisorVersion, this.hypervisorHost);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmProperties model) {
            if (model.wasPropertyExplicitlySet("hypervisorVendor")) {
                this.hypervisorVendor(model.getHypervisorVendor());
            }
            if (model.wasPropertyExplicitlySet("hypervisorVersion")) {
                this.hypervisorVersion(model.getHypervisorVersion());
            }
            if (model.wasPropertyExplicitlySet("hypervisorHost")) {
                this.hypervisorHost(model.getHypervisorHost());
            }
            return this;
        }
    }
}

