/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.ComputeProperties;
import com.oracle.bmc.cloudbridge.model.CreateAssetDetails;
import com.oracle.bmc.cloudbridge.model.VmProperties;
import com.oracle.bmc.cloudbridge.model.VmwareVCenterProperties;
import com.oracle.bmc.cloudbridge.model.VmwareVmProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="assetType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateVmwareVmAssetDetails
extends CreateAssetDetails {
    @JsonProperty(value="compute")
    private final ComputeProperties compute;
    @JsonProperty(value="vm")
    private final VmProperties vm;
    @JsonProperty(value="vmwareVm")
    private final VmwareVmProperties vmwareVm;
    @JsonProperty(value="vmwareVCenter")
    private final VmwareVCenterProperties vmwareVCenter;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateVmwareVmAssetDetails(String displayName, String inventoryId, String compartmentId, String sourceKey, String externalAssetKey, List<String> assetSourceIds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ComputeProperties compute, VmProperties vm, VmwareVmProperties vmwareVm, VmwareVCenterProperties vmwareVCenter) {
        super(displayName, inventoryId, compartmentId, sourceKey, externalAssetKey, assetSourceIds, freeformTags, definedTags);
        this.compute = compute;
        this.vm = vm;
        this.vmwareVm = vmwareVm;
        this.vmwareVCenter = vmwareVCenter;
    }

    public ComputeProperties getCompute() {
        return this.compute;
    }

    public VmProperties getVm() {
        return this.vm;
    }

    public VmwareVmProperties getVmwareVm() {
        return this.vmwareVm;
    }

    public VmwareVCenterProperties getVmwareVCenter() {
        return this.vmwareVCenter;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateVmwareVmAssetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compute=").append(String.valueOf((Object)this.compute));
        sb.append(", vm=").append(String.valueOf((Object)this.vm));
        sb.append(", vmwareVm=").append(String.valueOf((Object)this.vmwareVm));
        sb.append(", vmwareVCenter=").append(String.valueOf((Object)this.vmwareVCenter));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVmwareVmAssetDetails)) {
            return false;
        }
        CreateVmwareVmAssetDetails other = (CreateVmwareVmAssetDetails)((Object)o);
        return Objects.equals((Object)this.compute, (Object)other.compute) && Objects.equals((Object)this.vm, (Object)other.vm) && Objects.equals((Object)this.vmwareVm, (Object)other.vmwareVm) && Objects.equals((Object)this.vmwareVCenter, (Object)other.vmwareVCenter) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compute == null ? 43 : this.compute.hashCode());
        result = result * 59 + (this.vm == null ? 43 : this.vm.hashCode());
        result = result * 59 + (this.vmwareVm == null ? 43 : this.vmwareVm.hashCode());
        result = result * 59 + (this.vmwareVCenter == null ? 43 : this.vmwareVCenter.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="inventoryId")
        private String inventoryId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceKey")
        private String sourceKey;
        @JsonProperty(value="externalAssetKey")
        private String externalAssetKey;
        @JsonProperty(value="assetSourceIds")
        private List<String> assetSourceIds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="compute")
        private ComputeProperties compute;
        @JsonProperty(value="vm")
        private VmProperties vm;
        @JsonProperty(value="vmwareVm")
        private VmwareVmProperties vmwareVm;
        @JsonProperty(value="vmwareVCenter")
        private VmwareVCenterProperties vmwareVCenter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            this.__explicitlySet__.add("inventoryId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            this.__explicitlySet__.add("sourceKey");
            return this;
        }

        public Builder externalAssetKey(String externalAssetKey) {
            this.externalAssetKey = externalAssetKey;
            this.__explicitlySet__.add("externalAssetKey");
            return this;
        }

        public Builder assetSourceIds(List<String> assetSourceIds) {
            this.assetSourceIds = assetSourceIds;
            this.__explicitlySet__.add("assetSourceIds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder compute(ComputeProperties compute) {
            this.compute = compute;
            this.__explicitlySet__.add("compute");
            return this;
        }

        public Builder vm(VmProperties vm) {
            this.vm = vm;
            this.__explicitlySet__.add("vm");
            return this;
        }

        public Builder vmwareVm(VmwareVmProperties vmwareVm) {
            this.vmwareVm = vmwareVm;
            this.__explicitlySet__.add("vmwareVm");
            return this;
        }

        public Builder vmwareVCenter(VmwareVCenterProperties vmwareVCenter) {
            this.vmwareVCenter = vmwareVCenter;
            this.__explicitlySet__.add("vmwareVCenter");
            return this;
        }

        public CreateVmwareVmAssetDetails build() {
            CreateVmwareVmAssetDetails model = new CreateVmwareVmAssetDetails(this.displayName, this.inventoryId, this.compartmentId, this.sourceKey, this.externalAssetKey, this.assetSourceIds, this.freeformTags, this.definedTags, this.compute, this.vm, this.vmwareVm, this.vmwareVCenter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateVmwareVmAssetDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("inventoryId")) {
                this.inventoryId(model.getInventoryId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceKey")) {
                this.sourceKey(model.getSourceKey());
            }
            if (model.wasPropertyExplicitlySet("externalAssetKey")) {
                this.externalAssetKey(model.getExternalAssetKey());
            }
            if (model.wasPropertyExplicitlySet("assetSourceIds")) {
                this.assetSourceIds(model.getAssetSourceIds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("compute")) {
                this.compute(model.getCompute());
            }
            if (model.wasPropertyExplicitlySet("vm")) {
                this.vm(model.getVm());
            }
            if (model.wasPropertyExplicitlySet("vmwareVm")) {
                this.vmwareVm(model.getVmwareVm());
            }
            if (model.wasPropertyExplicitlySet("vmwareVCenter")) {
                this.vmwareVCenter(model.getVmwareVCenter());
            }
            return this;
        }
    }
}

