/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.PluginSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Agent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="agentType")
    private final AgentType agentType;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeLastSyncReceived")
    private final Date timeLastSyncReceived;
    @JsonProperty(value="heartBeatStatus")
    private final HeartBeatStatus heartBeatStatus;
    @JsonProperty(value="environmentId")
    private final String environmentId;
    @JsonProperty(value="agentPubKey")
    private final String agentPubKey;
    @JsonProperty(value="timeExpireAgentKeyInMs")
    private final Date timeExpireAgentKeyInMs;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="pluginList")
    private final List<PluginSummary> pluginList;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "agentType", "agentVersion", "osVersion", "timeCreated", "timeUpdated", "timeLastSyncReceived", "heartBeatStatus", "environmentId", "agentPubKey", "timeExpireAgentKeyInMs", "lifecycleState", "lifecycleDetails", "pluginList", "freeformTags", "definedTags", "systemTags"})
    public Agent(String id, String displayName, String compartmentId, AgentType agentType, String agentVersion, String osVersion, Date timeCreated, Date timeUpdated, Date timeLastSyncReceived, HeartBeatStatus heartBeatStatus, String environmentId, String agentPubKey, Date timeExpireAgentKeyInMs, LifecycleState lifecycleState, String lifecycleDetails, List<PluginSummary> pluginList, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.agentType = agentType;
        this.agentVersion = agentVersion;
        this.osVersion = osVersion;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeLastSyncReceived = timeLastSyncReceived;
        this.heartBeatStatus = heartBeatStatus;
        this.environmentId = environmentId;
        this.agentPubKey = agentPubKey;
        this.timeExpireAgentKeyInMs = timeExpireAgentKeyInMs;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.pluginList = pluginList;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeLastSyncReceived() {
        return this.timeLastSyncReceived;
    }

    public HeartBeatStatus getHeartBeatStatus() {
        return this.heartBeatStatus;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getAgentPubKey() {
        return this.agentPubKey;
    }

    public Date getTimeExpireAgentKeyInMs() {
        return this.timeExpireAgentKeyInMs;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<PluginSummary> getPluginList() {
        return this.pluginList;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Agent(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", agentType=").append(String.valueOf((Object)this.agentType));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeLastSyncReceived=").append(String.valueOf(this.timeLastSyncReceived));
        sb.append(", heartBeatStatus=").append(String.valueOf((Object)this.heartBeatStatus));
        sb.append(", environmentId=").append(String.valueOf(this.environmentId));
        sb.append(", agentPubKey=").append(String.valueOf(this.agentPubKey));
        sb.append(", timeExpireAgentKeyInMs=").append(String.valueOf(this.timeExpireAgentKeyInMs));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", pluginList=").append(String.valueOf(this.pluginList));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.agentType, (Object)other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeLastSyncReceived, other.timeLastSyncReceived) && Objects.equals((Object)this.heartBeatStatus, (Object)other.heartBeatStatus) && Objects.equals(this.environmentId, other.environmentId) && Objects.equals(this.agentPubKey, other.agentPubKey) && Objects.equals(this.timeExpireAgentKeyInMs, other.timeExpireAgentKeyInMs) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.pluginList, other.pluginList) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.agentType == null ? 43 : this.agentType.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeLastSyncReceived == null ? 43 : this.timeLastSyncReceived.hashCode());
        result = result * 59 + (this.heartBeatStatus == null ? 43 : this.heartBeatStatus.hashCode());
        result = result * 59 + (this.environmentId == null ? 43 : this.environmentId.hashCode());
        result = result * 59 + (this.agentPubKey == null ? 43 : this.agentPubKey.hashCode());
        result = result * 59 + (this.timeExpireAgentKeyInMs == null ? 43 : this.timeExpireAgentKeyInMs.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.pluginList == null ? 43 : this.pluginList.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum HeartBeatStatus implements BmcEnum
    {
        Healthy("HEALTHY"),
        Unhealthy("UNHEALTHY"),
        Failed("FAILED"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HeartBeatStatus> map;

        private HeartBeatStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HeartBeatStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HeartBeatStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HeartBeatStatus.class);
            map = new HashMap<String, HeartBeatStatus>();
            for (HeartBeatStatus v : HeartBeatStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AgentType implements BmcEnum
    {
        Appliance("APPLIANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AgentType> map;

        private AgentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AgentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AgentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AgentType.class);
            map = new HashMap<String, AgentType>();
            for (AgentType v : AgentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="agentType")
        private AgentType agentType;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeLastSyncReceived")
        private Date timeLastSyncReceived;
        @JsonProperty(value="heartBeatStatus")
        private HeartBeatStatus heartBeatStatus;
        @JsonProperty(value="environmentId")
        private String environmentId;
        @JsonProperty(value="agentPubKey")
        private String agentPubKey;
        @JsonProperty(value="timeExpireAgentKeyInMs")
        private Date timeExpireAgentKeyInMs;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="pluginList")
        private List<PluginSummary> pluginList;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder agentType(AgentType agentType) {
            this.agentType = agentType;
            this.__explicitlySet__.add("agentType");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeLastSyncReceived(Date timeLastSyncReceived) {
            this.timeLastSyncReceived = timeLastSyncReceived;
            this.__explicitlySet__.add("timeLastSyncReceived");
            return this;
        }

        public Builder heartBeatStatus(HeartBeatStatus heartBeatStatus) {
            this.heartBeatStatus = heartBeatStatus;
            this.__explicitlySet__.add("heartBeatStatus");
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            this.__explicitlySet__.add("environmentId");
            return this;
        }

        public Builder agentPubKey(String agentPubKey) {
            this.agentPubKey = agentPubKey;
            this.__explicitlySet__.add("agentPubKey");
            return this;
        }

        public Builder timeExpireAgentKeyInMs(Date timeExpireAgentKeyInMs) {
            this.timeExpireAgentKeyInMs = timeExpireAgentKeyInMs;
            this.__explicitlySet__.add("timeExpireAgentKeyInMs");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder pluginList(List<PluginSummary> pluginList) {
            this.pluginList = pluginList;
            this.__explicitlySet__.add("pluginList");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Agent build() {
            Agent model = new Agent(this.id, this.displayName, this.compartmentId, this.agentType, this.agentVersion, this.osVersion, this.timeCreated, this.timeUpdated, this.timeLastSyncReceived, this.heartBeatStatus, this.environmentId, this.agentPubKey, this.timeExpireAgentKeyInMs, this.lifecycleState, this.lifecycleDetails, this.pluginList, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Agent model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("agentType")) {
                this.agentType(model.getAgentType());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeLastSyncReceived")) {
                this.timeLastSyncReceived(model.getTimeLastSyncReceived());
            }
            if (model.wasPropertyExplicitlySet("heartBeatStatus")) {
                this.heartBeatStatus(model.getHeartBeatStatus());
            }
            if (model.wasPropertyExplicitlySet("environmentId")) {
                this.environmentId(model.getEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("agentPubKey")) {
                this.agentPubKey(model.getAgentPubKey());
            }
            if (model.wasPropertyExplicitlySet("timeExpireAgentKeyInMs")) {
                this.timeExpireAgentKeyInMs(model.getTimeExpireAgentKeyInMs());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("pluginList")) {
                this.pluginList(model.getPluginList());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

