/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.OcbAgentSvc;
import com.oracle.bmc.cloudbridge.OcbAgentSvcAsyncClient;
import com.oracle.bmc.cloudbridge.OcbAgentSvcPaginators;
import com.oracle.bmc.cloudbridge.OcbAgentSvcWaiters;
import com.oracle.bmc.cloudbridge.model.Agent;
import com.oracle.bmc.cloudbridge.model.AgentCollection;
import com.oracle.bmc.cloudbridge.model.AgentDependency;
import com.oracle.bmc.cloudbridge.model.AgentDependencyCollection;
import com.oracle.bmc.cloudbridge.model.ApplianceImageCollection;
import com.oracle.bmc.cloudbridge.model.Environment;
import com.oracle.bmc.cloudbridge.model.EnvironmentCollection;
import com.oracle.bmc.cloudbridge.model.Plugin;
import com.oracle.bmc.cloudbridge.requests.AddAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentDependencyCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeEnvironmentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentRequest;
import com.oracle.bmc.cloudbridge.requests.GetEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetPluginRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentDependenciesRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentsRequest;
import com.oracle.bmc.cloudbridge.requests.ListApplianceImagesRequest;
import com.oracle.bmc.cloudbridge.requests.ListEnvironmentsRequest;
import com.oracle.bmc.cloudbridge.requests.RemoveAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdatePluginRequest;
import com.oracle.bmc.cloudbridge.responses.AddAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentDependencyCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeEnvironmentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentResponse;
import com.oracle.bmc.cloudbridge.responses.GetEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetPluginResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentDependenciesResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentsResponse;
import com.oracle.bmc.cloudbridge.responses.ListApplianceImagesResponse;
import com.oracle.bmc.cloudbridge.responses.ListEnvironmentsResponse;
import com.oracle.bmc.cloudbridge.responses.RemoveAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdatePluginResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcbAgentSvcClient
extends BaseSyncClient
implements OcbAgentSvc {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCBAGENTSVC").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OcbAgentSvcAsyncClient.class);
    private final OcbAgentSvcWaiters waiters;
    private final OcbAgentSvcPaginators paginators;

    private OcbAgentSvcClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OcbAgentSvc-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OcbAgentSvcWaiters(executorService, this);
        this.paginators = new OcbAgentSvcPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddAgentDependencyResponse addAgentDependency(AddAgentDependencyRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddAgentDependencyDetails(), "addAgentDependencyDetails is required");
        return (AddAgentDependencyResponse)this.clientCall(request, AddAgentDependencyResponse::builder).logger(LOG, "addAgentDependency").serviceDetails("OcbAgentSvc", "AddAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/AddAgentDependency").method(Method.POST).requestBuilder(AddAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("addAgentDependency").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, AddAgentDependencyResponse.Builder::environment).handleResponseHeaderString("etag", AddAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddAgentDependencyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeAgentCompartmentResponse changeAgentCompartment(ChangeAgentCompartmentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentCompartmentDetails(), "changeAgentCompartmentDetails is required");
        return (ChangeAgentCompartmentResponse)this.clientCall(request, ChangeAgentCompartmentResponse::builder).logger(LOG, "changeAgentCompartment").serviceDetails("OcbAgentSvc", "ChangeAgentCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/ChangeAgentCompartment").method(Method.POST).requestBuilder(ChangeAgentCompartmentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAgentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAgentCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeAgentDependencyCompartmentResponse changeAgentDependencyCompartment(ChangeAgentDependencyCompartmentRequest request) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentDependencyCompartmentDetails(), "changeAgentDependencyCompartmentDetails is required");
        return (ChangeAgentDependencyCompartmentResponse)this.clientCall(request, ChangeAgentDependencyCompartmentResponse::builder).logger(LOG, "changeAgentDependencyCompartment").serviceDetails("OcbAgentSvc", "ChangeAgentDependencyCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/ChangeAgentDependencyCompartment").method(Method.POST).requestBuilder(ChangeAgentDependencyCompartmentRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAgentDependencyCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeEnvironmentCompartmentResponse changeEnvironmentCompartment(ChangeEnvironmentCompartmentRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEnvironmentCompartmentDetails(), "changeEnvironmentCompartmentDetails is required");
        return (ChangeEnvironmentCompartmentResponse)this.clientCall(request, ChangeEnvironmentCompartmentResponse::builder).logger(LOG, "changeEnvironmentCompartment").serviceDetails("OcbAgentSvc", "ChangeEnvironmentCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/ChangeEnvironmentCompartment").method(Method.POST).requestBuilder(ChangeEnvironmentCompartmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeEnvironmentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeEnvironmentCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateAgentResponse createAgent(CreateAgentRequest request) {
        Objects.requireNonNull(request.getCreateAgentDetails(), "createAgentDetails is required");
        return (CreateAgentResponse)this.clientCall(request, CreateAgentResponse::builder).logger(LOG, "createAgent").serviceDetails("OcbAgentSvc", "CreateAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/CreateAgent").method(Method.POST).requestBuilder(CreateAgentRequest::builder).basePath("/20220509").appendPathParam("agents").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Agent.class, CreateAgentResponse.Builder::agent).handleResponseHeaderString("etag", CreateAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAgentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateAgentDependencyResponse createAgentDependency(CreateAgentDependencyRequest request) {
        Objects.requireNonNull(request.getCreateAgentDependencyDetails(), "createAgentDependencyDetails is required");
        return (CreateAgentDependencyResponse)this.clientCall(request, CreateAgentDependencyResponse::builder).logger(LOG, "createAgentDependency").serviceDetails("OcbAgentSvc", "CreateAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/CreateAgentDependency").method(Method.POST).requestBuilder(CreateAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AgentDependency.class, CreateAgentDependencyResponse.Builder::agentDependency).handleResponseHeaderString("etag", CreateAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAgentDependencyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAgentDependencyResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest request) {
        Objects.requireNonNull(request.getCreateEnvironmentDetails(), "createEnvironmentDetails is required");
        return (CreateEnvironmentResponse)this.clientCall(request, CreateEnvironmentResponse::builder).logger(LOG, "createEnvironment").serviceDetails("OcbAgentSvc", "CreateEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/CreateEnvironment").method(Method.POST).requestBuilder(CreateEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, CreateEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", CreateEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEnvironmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteAgentResponse deleteAgent(DeleteAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return (DeleteAgentResponse)this.clientCall(request, DeleteAgentResponse::builder).logger(LOG, "deleteAgent").serviceDetails("OcbAgentSvc", "DeleteAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/DeleteAgent").method(Method.DELETE).requestBuilder(DeleteAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteAgentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteAgentDependencyResponse deleteAgentDependency(DeleteAgentDependencyRequest request) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        return (DeleteAgentDependencyResponse)this.clientCall(request, DeleteAgentDependencyResponse::builder).logger(LOG, "deleteAgentDependency").serviceDetails("OcbAgentSvc", "DeleteAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/DeleteAgentDependency").method(Method.DELETE).requestBuilder(DeleteAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAgentDependencyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        return (DeleteEnvironmentResponse)this.clientCall(request, DeleteEnvironmentResponse::builder).logger(LOG, "deleteEnvironment").serviceDetails("OcbAgentSvc", "DeleteEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/DeleteEnvironment").method(Method.DELETE).requestBuilder(DeleteEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteEnvironmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAgentResponse getAgent(GetAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return (GetAgentResponse)this.clientCall(request, GetAgentResponse::builder).logger(LOG, "getAgent").serviceDetails("OcbAgentSvc", "GetAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/GetAgent").method(Method.GET).requestBuilder(GetAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Agent.class, GetAgentResponse.Builder::agent).handleResponseHeaderString("etag", GetAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAgentDependencyResponse getAgentDependency(GetAgentDependencyRequest request) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        return (GetAgentDependencyResponse)this.clientCall(request, GetAgentDependencyResponse::builder).logger(LOG, "getAgentDependency").serviceDetails("OcbAgentSvc", "GetAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/GetAgentDependency").method(Method.GET).requestBuilder(GetAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentDependency.class, GetAgentDependencyResponse.Builder::agentDependency).handleResponseHeaderString("etag", GetAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentDependencyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetEnvironmentResponse getEnvironment(GetEnvironmentRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        return (GetEnvironmentResponse)this.clientCall(request, GetEnvironmentResponse::builder).logger(LOG, "getEnvironment").serviceDetails("OcbAgentSvc", "GetEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/GetEnvironment").method(Method.GET).requestBuilder(GetEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Environment.class, GetEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", GetEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEnvironmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetPluginResponse getPlugin(GetPluginRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPluginName(), (String)"pluginName must not be blank", (Object[])new Object[0]);
        return (GetPluginResponse)this.clientCall(request, GetPluginResponse::builder).logger(LOG, "getPlugin").serviceDetails("OcbAgentSvc", "GetPlugin", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Plugin/GetPlugin").method(Method.GET).requestBuilder(GetPluginRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("plugins").appendPathParam(request.getPluginName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Plugin.class, GetPluginResponse.Builder::plugin).handleResponseHeaderString("etag", GetPluginResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPluginResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAgentDependenciesResponse listAgentDependencies(ListAgentDependenciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAgentDependenciesResponse)this.clientCall(request, ListAgentDependenciesResponse::builder).logger(LOG, "listAgentDependencies").serviceDetails("OcbAgentSvc", "ListAgentDependencies", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependencyCollection/ListAgentDependencies").method(Method.GET).requestBuilder(ListAgentDependenciesRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("agentId", (Object)request.getAgentId()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentDependencyCollection.class, ListAgentDependenciesResponse.Builder::agentDependencyCollection).handleResponseHeaderString("opc-request-id", ListAgentDependenciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentDependenciesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAgentsResponse listAgents(ListAgentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAgentsResponse)this.clientCall(request, ListAgentsResponse::builder).logger(LOG, "listAgents").serviceDetails("OcbAgentSvc", "ListAgents", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentCollection/ListAgents").method(Method.GET).requestBuilder(ListAgentsRequest::builder).basePath("/20220509").appendPathParam("agents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("agentId", (Object)request.getAgentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentCollection.class, ListAgentsResponse.Builder::agentCollection).handleResponseHeaderString("opc-request-id", ListAgentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListApplianceImagesResponse listApplianceImages(ListApplianceImagesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListApplianceImagesResponse)this.clientCall(request, ListApplianceImagesResponse::builder).logger(LOG, "listApplianceImages").serviceDetails("OcbAgentSvc", "ListApplianceImages", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/ApplianceImageCollection/ListApplianceImages").method(Method.GET).requestBuilder(ListApplianceImagesRequest::builder).basePath("/20220509").appendPathParam("applianceImages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplianceImageCollection.class, ListApplianceImagesResponse.Builder::applianceImageCollection).handleResponseHeaderString("opc-request-id", ListApplianceImagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplianceImagesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEnvironmentsResponse)this.clientCall(request, ListEnvironmentsResponse::builder).logger(LOG, "listEnvironments").serviceDetails("OcbAgentSvc", "ListEnvironments", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/EnvironmentCollection/ListEnvironments").method(Method.GET).requestBuilder(ListEnvironmentsRequest::builder).basePath("/20220509").appendPathParam("environments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnvironmentCollection.class, ListEnvironmentsResponse.Builder::environmentCollection).handleResponseHeaderString("opc-request-id", ListEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEnvironmentsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveAgentDependencyResponse removeAgentDependency(RemoveAgentDependencyRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveAgentDependencyDetails(), "removeAgentDependencyDetails is required");
        return (RemoveAgentDependencyResponse)this.clientCall(request, RemoveAgentDependencyResponse::builder).logger(LOG, "removeAgentDependency").serviceDetails("OcbAgentSvc", "RemoveAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/RemoveAgentDependency").method(Method.POST).requestBuilder(RemoveAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("removeAgentDependency").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, RemoveAgentDependencyResponse.Builder::environment).handleResponseHeaderString("etag", RemoveAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveAgentDependencyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAgentResponse updateAgent(UpdateAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDetails(), "updateAgentDetails is required");
        return (UpdateAgentResponse)this.clientCall(request, UpdateAgentResponse::builder).logger(LOG, "updateAgent").serviceDetails("OcbAgentSvc", "UpdateAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/UpdateAgent").method(Method.PUT).requestBuilder(UpdateAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Agent.class, UpdateAgentResponse.Builder::agent).handleResponseHeaderString("etag", UpdateAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAgentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAgentDependencyResponse updateAgentDependency(UpdateAgentDependencyRequest request) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDependencyDetails(), "updateAgentDependencyDetails is required");
        return (UpdateAgentDependencyResponse)this.clientCall(request, UpdateAgentDependencyResponse::builder).logger(LOG, "updateAgentDependency").serviceDetails("OcbAgentSvc", "UpdateAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/UpdateAgentDependency").method(Method.PUT).requestBuilder(UpdateAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAgentDependencyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAgentDependencyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest request) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEnvironmentDetails(), "updateEnvironmentDetails is required");
        return (UpdateEnvironmentResponse)this.clientCall(request, UpdateEnvironmentResponse::builder).logger(LOG, "updateEnvironment").serviceDetails("OcbAgentSvc", "UpdateEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/UpdateEnvironment").method(Method.PUT).requestBuilder(UpdateEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Environment.class, UpdateEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", UpdateEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEnvironmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdatePluginResponse updatePlugin(UpdatePluginRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPluginName(), (String)"pluginName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePluginDetails(), "updatePluginDetails is required");
        return (UpdatePluginResponse)this.clientCall(request, UpdatePluginResponse::builder).logger(LOG, "updatePlugin").serviceDetails("OcbAgentSvc", "UpdatePlugin", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Plugin/UpdatePlugin").method(Method.PUT).requestBuilder(UpdatePluginRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("plugins").appendPathParam(request.getPluginName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Plugin.class, UpdatePluginResponse.Builder::plugin).handleResponseHeaderString("etag", UpdatePluginResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePluginResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public OcbAgentSvcWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OcbAgentSvcPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OcbAgentSvcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OcbAgentSvcClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OcbAgentSvcClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OcbAgentSvcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OcbAgentSvcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OcbAgentSvcClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OcbAgentSvcClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OcbAgentSvcClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

