/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.InventoryAsync;
import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.AssetAggregationCollection;
import com.oracle.bmc.cloudbridge.model.AssetCollection;
import com.oracle.bmc.cloudbridge.model.HistoricalMetricCollection;
import com.oracle.bmc.cloudbridge.model.Inventory;
import com.oracle.bmc.cloudbridge.model.InventoryCollection;
import com.oracle.bmc.cloudbridge.requests.AnalyzeAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetTagsRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.CreateInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetRequest;
import com.oracle.bmc.cloudbridge.requests.GetInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ImportInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ListHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.ListInventoriesRequest;
import com.oracle.bmc.cloudbridge.requests.SubmitHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateInventoryRequest;
import com.oracle.bmc.cloudbridge.responses.AnalyzeAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetTagsResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.CreateInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetResponse;
import com.oracle.bmc.cloudbridge.responses.GetInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ImportInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ListHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.ListInventoriesResponse;
import com.oracle.bmc.cloudbridge.responses.SubmitHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateInventoryResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryAsyncClient
extends BaseAsyncClient
implements InventoryAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INVENTORY").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(InventoryAsyncClient.class);

    private InventoryAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AnalyzeAssetsResponse> analyzeAssets(AnalyzeAssetsRequest request, AsyncHandler<AnalyzeAssetsRequest, AnalyzeAssetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAggregationProperties(), "aggregationProperties is required");
        return this.clientCall(request, AnalyzeAssetsResponse::builder).logger(LOG, "analyzeAssets").serviceDetails("Inventory", "AnalyzeAssets", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetAggregation/AnalyzeAssets").method(Method.GET).requestBuilder(AnalyzeAssetsRequest::builder).basePath("/20220509").appendPathParam("assetAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("sourceKey", (Object)request.getSourceKey()).appendQueryParam("externalAssetKey", (Object)request.getExternalAssetKey()).appendEnumQueryParam("assetType", (BmcEnum)request.getAssetType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("aggregationProperties", request.getAggregationProperties(), CollectionFormatType.Multi).appendListQueryParam("groupBy", request.getGroupBy(), CollectionFormatType.Multi).appendQueryParam("inventoryId", (Object)request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetAggregationCollection.class, AnalyzeAssetsResponse.Builder::assetAggregationCollection).handleResponseHeaderString("opc-request-id", AnalyzeAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", AnalyzeAssetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ChangeAssetCompartmentResponse> changeAssetCompartment(ChangeAssetCompartmentRequest request, AsyncHandler<ChangeAssetCompartmentRequest, ChangeAssetCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetCompartmentDetails(), "changeAssetCompartmentDetails is required");
        return this.clientCall(request, ChangeAssetCompartmentResponse::builder).logger(LOG, "changeAssetCompartment").serviceDetails("Inventory", "ChangeAssetCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/ChangeAssetCompartment").method(Method.POST).requestBuilder(ChangeAssetCompartmentRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAssetCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAssetTagsResponse> changeAssetTags(ChangeAssetTagsRequest request, AsyncHandler<ChangeAssetTagsRequest, ChangeAssetTagsResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetTagsDetails(), "changeAssetTagsDetails is required");
        return this.clientCall(request, ChangeAssetTagsResponse::builder).logger(LOG, "changeAssetTags").serviceDetails("Inventory", "ChangeAssetTags", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/ChangeAssetTags").method(Method.POST).requestBuilder(ChangeAssetTagsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("changeTags").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Asset.class, ChangeAssetTagsResponse.Builder::asset).handleResponseHeaderString("etag", ChangeAssetTagsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeAssetTagsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAssetResponse> createAsset(CreateAssetRequest request, AsyncHandler<CreateAssetRequest, CreateAssetResponse> handler) {
        Objects.requireNonNull(request.getCreateAssetDetails(), "createAssetDetails is required");
        return this.clientCall(request, CreateAssetResponse::builder).logger(LOG, "createAsset").serviceDetails("Inventory", "CreateAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/CreateAsset").method(Method.POST).requestBuilder(CreateAssetRequest::builder).basePath("/20220509").appendPathParam("assets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Asset.class, CreateAssetResponse.Builder::asset).handleResponseHeaderString("etag", CreateAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateInventoryResponse> createInventory(CreateInventoryRequest request, AsyncHandler<CreateInventoryRequest, CreateInventoryResponse> handler) {
        Objects.requireNonNull(request.getCreateInventoryDetails(), "createInventoryDetails is required");
        return this.clientCall(request, CreateInventoryResponse::builder).logger(LOG, "createInventory").serviceDetails("Inventory", "CreateInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/CreateInventory").method(Method.POST).requestBuilder(CreateInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateInventoryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAssetResponse> deleteAsset(DeleteAssetRequest request, AsyncHandler<DeleteAssetRequest, DeleteAssetResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAssetResponse::builder).logger(LOG, "deleteAsset").serviceDetails("Inventory", "DeleteAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/DeleteAsset").method(Method.DELETE).requestBuilder(DeleteAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteInventoryResponse> deleteInventory(DeleteInventoryRequest request, AsyncHandler<DeleteInventoryRequest, DeleteInventoryResponse> handler) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteInventoryResponse::builder).logger(LOG, "deleteInventory").serviceDetails("Inventory", "DeleteInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/DeleteInventory").method(Method.DELETE).requestBuilder(DeleteInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteInventoryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAssetResponse> getAsset(GetAssetRequest request, AsyncHandler<GetAssetRequest, GetAssetResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAssetResponse::builder).logger(LOG, "getAsset").serviceDetails("Inventory", "GetAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/GetAsset").method(Method.GET).requestBuilder(GetAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Asset.class, GetAssetResponse.Builder::asset).handleResponseHeaderString("etag", GetAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInventoryResponse> getInventory(GetInventoryRequest request, AsyncHandler<GetInventoryRequest, GetInventoryResponse> handler) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInventoryResponse::builder).logger(LOG, "getInventory").serviceDetails("Inventory", "GetInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/GetInventory").method(Method.GET).requestBuilder(GetInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Inventory.class, GetInventoryResponse.Builder::inventory).handleResponseHeaderString("etag", GetInventoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GetInventoryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ImportInventoryResponse> importInventory(ImportInventoryRequest request, AsyncHandler<ImportInventoryRequest, ImportInventoryResponse> handler) {
        Objects.requireNonNull(request.getImportInventoryDetails(), "importInventoryDetails is required");
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ImportInventoryResponse::builder).logger(LOG, "importInventory").serviceDetails("Inventory", "ImportInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/ImportInventory").method(Method.POST).requestBuilder(ImportInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).appendPathParam("actions").appendPathParam("import").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ImportInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ImportInventoryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAssetsResponse> listAssets(ListAssetsRequest request, AsyncHandler<ListAssetsRequest, ListAssetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAssetsResponse::builder).logger(LOG, "listAssets").serviceDetails("Inventory", "ListAssets", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetCollection/ListAssets").method(Method.GET).requestBuilder(ListAssetsRequest::builder).basePath("/20220509").appendPathParam("assets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("sourceKey", (Object)request.getSourceKey()).appendQueryParam("externalAssetKey", (Object)request.getExternalAssetKey()).appendEnumQueryParam("assetType", (BmcEnum)request.getAssetType()).appendQueryParam("assetId", (Object)request.getAssetId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("inventoryId", (Object)request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetCollection.class, ListAssetsResponse.Builder::assetCollection).handleResponseHeaderString("opc-request-id", ListAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListHistoricalMetricsResponse> listHistoricalMetrics(ListHistoricalMetricsRequest request, AsyncHandler<ListHistoricalMetricsRequest, ListHistoricalMetricsResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListHistoricalMetricsResponse::builder).logger(LOG, "listHistoricalMetrics").serviceDetails("Inventory", "ListHistoricalMetrics", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/HistoricalMetric/ListHistoricalMetrics").method(Method.GET).requestBuilder(ListHistoricalMetricsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("historicalMetrics").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HistoricalMetricCollection.class, ListHistoricalMetricsResponse.Builder::historicalMetricCollection).handleResponseHeaderString("opc-request-id", ListHistoricalMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHistoricalMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListInventoriesResponse> listInventories(ListInventoriesRequest request, AsyncHandler<ListInventoriesRequest, ListInventoriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInventoriesResponse::builder).logger(LOG, "listInventories").serviceDetails("Inventory", "ListInventories", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/ListInventories").method(Method.GET).requestBuilder(ListInventoriesRequest::builder).basePath("/20220509").appendPathParam("inventories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InventoryCollection.class, ListInventoriesResponse.Builder::inventoryCollection).handleResponseHeaderString("opc-request-id", ListInventoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInventoriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SubmitHistoricalMetricsResponse> submitHistoricalMetrics(SubmitHistoricalMetricsRequest request, AsyncHandler<SubmitHistoricalMetricsRequest, SubmitHistoricalMetricsResponse> handler) {
        Objects.requireNonNull(request.getSubmitHistoricalMetricsDetails(), "submitHistoricalMetricsDetails is required");
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SubmitHistoricalMetricsResponse::builder).logger(LOG, "submitHistoricalMetrics").serviceDetails("Inventory", "SubmitHistoricalMetrics", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/HistoricalMetric/SubmitHistoricalMetrics").method(Method.POST).requestBuilder(SubmitHistoricalMetricsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("submitHistoricalMetrics").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HistoricalMetricCollection.class, SubmitHistoricalMetricsResponse.Builder::historicalMetricCollection).handleResponseHeaderString("etag", SubmitHistoricalMetricsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SubmitHistoricalMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAssetResponse> updateAsset(UpdateAssetRequest request, AsyncHandler<UpdateAssetRequest, UpdateAssetResponse> handler) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAssetDetails(), "updateAssetDetails is required");
        return this.clientCall(request, UpdateAssetResponse::builder).logger(LOG, "updateAsset").serviceDetails("Inventory", "UpdateAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/UpdateAsset").method(Method.PUT).requestBuilder(UpdateAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Asset.class, UpdateAssetResponse.Builder::asset).handleResponseHeaderString("etag", UpdateAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateInventoryResponse> updateInventory(UpdateInventoryRequest request, AsyncHandler<UpdateInventoryRequest, UpdateInventoryResponse> handler) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInventoryDetails(), "updateInventoryDetails is required");
        return this.clientCall(request, UpdateInventoryResponse::builder).logger(LOG, "updateInventory").serviceDetails("Inventory", "UpdateInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/UpdateInventory").method(Method.PUT).requestBuilder(UpdateInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Inventory.class, UpdateInventoryResponse.Builder::inventory).handleResponseHeaderString("etag", UpdateInventoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInventoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public InventoryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)InventoryAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(InventoryAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)InventoryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)InventoryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)InventoryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)InventoryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public InventoryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InventoryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, InventoryAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public InventoryAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new InventoryAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

