/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker.internal;

import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.circuitbreaker.internal.HttpStatusErrorException;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;
import lombok.NonNull;

final class PostCircuitBreakerFuture
implements Future<Response> {
    private final Future<Response> future;
    private final boolean writableStackTrace;

    PostCircuitBreakerFuture(@NonNull Future<Response> future, boolean writableStackTrace) {
        if (future == null) {
            throw new NullPointerException("future is marked @NonNull but is null");
        }
        this.future = future;
        this.writableStackTrace = writableStackTrace;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Response get() throws InterruptedException, ExecutionException {
        try {
            return this.future.get();
        }
        catch (HttpStatusErrorException e) {
            return e.getResponse();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CallNotPermittedException) {
                throw CallNotAllowedException.createCallNotAllowedException(e.getCause().getMessage(), this.writableStackTrace);
            }
            throw e;
        }
    }

    @Override
    public Response get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException("unit is marked @NonNull but is null");
        }
        try {
            return this.future.get(timeout, unit);
        }
        catch (HttpStatusErrorException e) {
            return e.getResponse();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CallNotPermittedException) {
                throw CallNotAllowedException.createCallNotAllowedException(e.getCause().getMessage(), this.writableStackTrace);
            }
            throw e;
        }
    }
}

