/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.JaxRsCircuitBreaker;
import com.oracle.bmc.circuitbreaker.internal.HttpStatusErrorException;
import com.oracle.bmc.circuitbreaker.internal.PostCircuitBreakerFuture;
import com.oracle.bmc.circuitbreaker.internal.PreCircuitBreakerFuture;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class JaxRsCircuitBreakerImpl
implements JaxRsCircuitBreaker {
    private final CircuitBreaker circuitBreaker;
    private final Set<Integer> recordHttpStatuses;

    public JaxRsCircuitBreakerImpl(CircuitBreakerConfiguration configuration) {
        CircuitBreakerConfig.Builder custom = CircuitBreakerConfig.custom();
        custom.enableAutomaticTransitionFromOpenToHalfOpen();
        custom.slidingWindowType(CircuitBreakerConfig.SlidingWindowType.COUNT_BASED);
        custom.failureRateThreshold((float)configuration.getFailureRateThreshold());
        custom.slowCallRateThreshold((float)configuration.getSlowCallRateThreshold());
        custom.slowCallDurationThreshold(configuration.getSlowCallDurationThreshold());
        custom.permittedNumberOfCallsInHalfOpenState(configuration.getPermittedNumberOfCallsInHalfOpenState());
        custom.slidingWindowSize(configuration.getSlidingWindowSize());
        custom.minimumNumberOfCalls(configuration.getMinimumNumberOfCalls());
        custom.writableStackTraceEnabled(configuration.isWritableStackTraceEnabled());
        Class[] exs = new Class[configuration.getRecordExceptions().size() + 1];
        for (int i = 0; i < configuration.getRecordExceptions().size(); ++i) {
            exs[i] = configuration.getRecordExceptions().get(i);
        }
        exs[configuration.getRecordExceptions().size()] = HttpStatusErrorException.class;
        custom.recordExceptions(exs);
        custom.waitDurationInOpenState(configuration.getWaitDurationInOpenState());
        this.circuitBreaker = CircuitBreaker.of((String)"default", (CircuitBreakerConfig)custom.build());
        this.recordHttpStatuses = configuration.getRecordHttpStatuses();
    }

    @Override
    public Supplier<Response> decorateSupplier(Supplier<Response> supplier) {
        Supplier circuitBreakerSupplier = this.circuitBreaker.decorateSupplier(() -> {
            Response response = (Response)supplier.get();
            if (this.recordHttpStatuses.contains(response.getStatus())) {
                throw new HttpStatusErrorException(response);
            }
            return response;
        });
        return () -> this.lambda$decorateSupplier$1((Supplier)circuitBreakerSupplier);
    }

    @Override
    public Function<Invocation, Response> decorateFunction(Function<Invocation, Response> function) {
        Function circuitBreakerFunction = CircuitBreaker.decorateFunction((CircuitBreaker)this.circuitBreaker, inv -> {
            Response response = (Response)function.apply((Invocation)inv);
            if (this.recordHttpStatuses.contains(response.getStatus())) {
                throw new HttpStatusErrorException(response);
            }
            return response;
        });
        return inv -> {
            try {
                return (Response)circuitBreakerFunction.apply(inv);
            }
            catch (HttpStatusErrorException e) {
                return e.getResponse();
            }
            catch (CallNotPermittedException e) {
                throw CallNotAllowedException.createCallNotAllowedException(e.getMessage(), this.circuitBreaker.getCircuitBreakerConfig().isWritableStackTraceEnabled());
            }
        };
    }

    @Override
    public Supplier<Future<Response>> decorateFuture(Supplier<Future<Response>> supplier) {
        Supplier circuitBreakerFuture = this.circuitBreaker.decorateFuture(() -> new PreCircuitBreakerFuture((Future)supplier.get(), this.recordHttpStatuses));
        return () -> this.lambda$decorateFuture$5((Supplier)circuitBreakerFuture);
    }

    @VisibleForTesting
    CircuitBreaker getInternalCircuitBreaker() {
        return this.circuitBreaker;
    }

    @VisibleForTesting
    CircuitBreakerConfig getInternalCircuitBreakerConfig() {
        return this.circuitBreaker.getCircuitBreakerConfig();
    }

    @VisibleForTesting
    Set<Integer> getRecordHttpStatuses() {
        return this.recordHttpStatuses;
    }

    private /* synthetic */ Future lambda$decorateFuture$5(Supplier circuitBreakerFuture) {
        return new PostCircuitBreakerFuture((Future)circuitBreakerFuture.get(), this.circuitBreaker.getCircuitBreakerConfig().isWritableStackTraceEnabled());
    }

    private /* synthetic */ Response lambda$decorateSupplier$1(Supplier circuitBreakerSupplier) {
        try {
            return (Response)circuitBreakerSupplier.get();
        }
        catch (HttpStatusErrorException e) {
            return e.getResponse();
        }
        catch (CallNotPermittedException e) {
            throw CallNotAllowedException.createCallNotAllowedException(e.getMessage(), this.circuitBreaker.getCircuitBreakerConfig().isWritableStackTraceEnabled());
        }
    }
}

