/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;

public class CircuitBreakerConfiguration {
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 50;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_PERMITTED_CALLS_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 100;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 100;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60;
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    public static final int TOO_MANY_REQUESTS = Response.Status.TOO_MANY_REQUESTS.getStatusCode();
    public static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    public static final int SERVICE_UNAVAILABLE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    private final int failureRateThreshold;
    private final int slowCallRateThreshold;
    private final Duration waitDurationInOpenState;
    private final int permittedNumberOfCallsInHalfOpenState;
    private final int minimumNumberOfCalls;
    private final int slidingWindowSize;
    private final Duration slowCallDurationThreshold;
    private final boolean writableStackTraceEnabled;
    private final Set<Integer> recordHttpStatuses;
    public static final Class<ProcessingException> PROCESSING_EXCEPTION_CLASS = ProcessingException.class;
    public static final Class<ServiceUnavailableException> SERVICE_UNAVAILABLE_EXCEPTION_CLASS = ServiceUnavailableException.class;
    public static final Class<InternalServerErrorException> INTERNAL_SERVER_ERROR_EXCEPTION_CLASS = InternalServerErrorException.class;
    private final List<Class<? extends RuntimeException>> recordExceptions;

    private static int $default$failureRateThreshold() {
        return 50;
    }

    private static int $default$slowCallRateThreshold() {
        return 100;
    }

    private static Duration $default$waitDurationInOpenState() {
        return Duration.ofSeconds(60L);
    }

    private static int $default$permittedNumberOfCallsInHalfOpenState() {
        return 10;
    }

    private static int $default$minimumNumberOfCalls() {
        return 100;
    }

    private static int $default$slidingWindowSize() {
        return 100;
    }

    private static Duration $default$slowCallDurationThreshold() {
        return Duration.ofSeconds(60L);
    }

    private static boolean $default$writableStackTraceEnabled() {
        return true;
    }

    private static Set<Integer> $default$recordHttpStatuses() {
        return Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(TOO_MANY_REQUESTS, INTERNAL_SERVER_ERROR, SERVICE_UNAVAILABLE)));
    }

    private static List<Class<? extends RuntimeException>> $default$recordExceptions() {
        return Collections.unmodifiableList(Arrays.asList(PROCESSING_EXCEPTION_CLASS, SERVICE_UNAVAILABLE_EXCEPTION_CLASS, INTERNAL_SERVER_ERROR_EXCEPTION_CLASS));
    }

    @ConstructorProperties(value={"failureRateThreshold", "slowCallRateThreshold", "waitDurationInOpenState", "permittedNumberOfCallsInHalfOpenState", "minimumNumberOfCalls", "slidingWindowSize", "slowCallDurationThreshold", "writableStackTraceEnabled", "recordHttpStatuses", "recordExceptions"})
    CircuitBreakerConfiguration(int failureRateThreshold, int slowCallRateThreshold, Duration waitDurationInOpenState, int permittedNumberOfCallsInHalfOpenState, int minimumNumberOfCalls, int slidingWindowSize, Duration slowCallDurationThreshold, boolean writableStackTraceEnabled, Set<Integer> recordHttpStatuses, List<Class<? extends RuntimeException>> recordExceptions) {
        this.failureRateThreshold = failureRateThreshold;
        this.slowCallRateThreshold = slowCallRateThreshold;
        this.waitDurationInOpenState = waitDurationInOpenState;
        this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
        this.minimumNumberOfCalls = minimumNumberOfCalls;
        this.slidingWindowSize = slidingWindowSize;
        this.slowCallDurationThreshold = slowCallDurationThreshold;
        this.writableStackTraceEnabled = writableStackTraceEnabled;
        this.recordHttpStatuses = recordHttpStatuses;
        this.recordExceptions = recordExceptions;
    }

    public static CircuitBreakerConfigurationBuilder builder() {
        return new CircuitBreakerConfigurationBuilder();
    }

    public int getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public int getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public Duration getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public Duration getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public Set<Integer> getRecordHttpStatuses() {
        return this.recordHttpStatuses;
    }

    public List<Class<? extends RuntimeException>> getRecordExceptions() {
        return this.recordExceptions;
    }

    public static class CircuitBreakerConfigurationBuilder {
        private boolean failureRateThreshold$set;
        private int failureRateThreshold;
        private boolean slowCallRateThreshold$set;
        private int slowCallRateThreshold;
        private boolean waitDurationInOpenState$set;
        private Duration waitDurationInOpenState;
        private boolean permittedNumberOfCallsInHalfOpenState$set;
        private int permittedNumberOfCallsInHalfOpenState;
        private boolean minimumNumberOfCalls$set;
        private int minimumNumberOfCalls;
        private boolean slidingWindowSize$set;
        private int slidingWindowSize;
        private boolean slowCallDurationThreshold$set;
        private Duration slowCallDurationThreshold;
        private boolean writableStackTraceEnabled$set;
        private boolean writableStackTraceEnabled;
        private boolean recordHttpStatuses$set;
        private Set<Integer> recordHttpStatuses;
        private boolean recordExceptions$set;
        private List<Class<? extends RuntimeException>> recordExceptions;

        CircuitBreakerConfigurationBuilder() {
        }

        public CircuitBreakerConfigurationBuilder failureRateThreshold(int failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
            this.failureRateThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slowCallRateThreshold(int slowCallRateThreshold) {
            this.slowCallRateThreshold = slowCallRateThreshold;
            this.slowCallRateThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder waitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState = waitDurationInOpenState;
            this.waitDurationInOpenState$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder permittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
            this.permittedNumberOfCallsInHalfOpenState$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder minimumNumberOfCalls(int minimumNumberOfCalls) {
            this.minimumNumberOfCalls = minimumNumberOfCalls;
            this.minimumNumberOfCalls$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slidingWindowSize(int slidingWindowSize) {
            this.slidingWindowSize = slidingWindowSize;
            this.slidingWindowSize$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slowCallDurationThreshold(Duration slowCallDurationThreshold) {
            this.slowCallDurationThreshold = slowCallDurationThreshold;
            this.slowCallDurationThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            this.writableStackTraceEnabled$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder recordHttpStatuses(Set<Integer> recordHttpStatuses) {
            this.recordHttpStatuses = recordHttpStatuses;
            this.recordHttpStatuses$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder recordExceptions(List<Class<? extends RuntimeException>> recordExceptions) {
            this.recordExceptions = recordExceptions;
            this.recordExceptions$set = true;
            return this;
        }

        public CircuitBreakerConfiguration build() {
            int failureRateThreshold = this.failureRateThreshold;
            if (!this.failureRateThreshold$set) {
                failureRateThreshold = CircuitBreakerConfiguration.$default$failureRateThreshold();
            }
            int slowCallRateThreshold = this.slowCallRateThreshold;
            if (!this.slowCallRateThreshold$set) {
                slowCallRateThreshold = CircuitBreakerConfiguration.$default$slowCallRateThreshold();
            }
            Duration waitDurationInOpenState = this.waitDurationInOpenState;
            if (!this.waitDurationInOpenState$set) {
                waitDurationInOpenState = CircuitBreakerConfiguration.$default$waitDurationInOpenState();
            }
            int permittedNumberOfCallsInHalfOpenState = this.permittedNumberOfCallsInHalfOpenState;
            if (!this.permittedNumberOfCallsInHalfOpenState$set) {
                permittedNumberOfCallsInHalfOpenState = CircuitBreakerConfiguration.$default$permittedNumberOfCallsInHalfOpenState();
            }
            int minimumNumberOfCalls = this.minimumNumberOfCalls;
            if (!this.minimumNumberOfCalls$set) {
                minimumNumberOfCalls = CircuitBreakerConfiguration.$default$minimumNumberOfCalls();
            }
            int slidingWindowSize = this.slidingWindowSize;
            if (!this.slidingWindowSize$set) {
                slidingWindowSize = CircuitBreakerConfiguration.$default$slidingWindowSize();
            }
            Duration slowCallDurationThreshold = this.slowCallDurationThreshold;
            if (!this.slowCallDurationThreshold$set) {
                slowCallDurationThreshold = CircuitBreakerConfiguration.$default$slowCallDurationThreshold();
            }
            boolean writableStackTraceEnabled = this.writableStackTraceEnabled;
            if (!this.writableStackTraceEnabled$set) {
                writableStackTraceEnabled = CircuitBreakerConfiguration.$default$writableStackTraceEnabled();
            }
            Set recordHttpStatuses = this.recordHttpStatuses;
            if (!this.recordHttpStatuses$set) {
                recordHttpStatuses = CircuitBreakerConfiguration.$default$recordHttpStatuses();
            }
            List recordExceptions = this.recordExceptions;
            if (!this.recordExceptions$set) {
                recordExceptions = CircuitBreakerConfiguration.$default$recordExceptions();
            }
            return new CircuitBreakerConfiguration(failureRateThreshold, slowCallRateThreshold, waitDurationInOpenState, permittedNumberOfCallsInHalfOpenState, minimumNumberOfCalls, slidingWindowSize, slowCallDurationThreshold, writableStackTraceEnabled, recordHttpStatuses, recordExceptions);
        }

        public String toString() {
            return "CircuitBreakerConfiguration.CircuitBreakerConfigurationBuilder(failureRateThreshold=" + this.failureRateThreshold + ", slowCallRateThreshold=" + this.slowCallRateThreshold + ", waitDurationInOpenState=" + this.waitDurationInOpenState + ", permittedNumberOfCallsInHalfOpenState=" + this.permittedNumberOfCallsInHalfOpenState + ", minimumNumberOfCalls=" + this.minimumNumberOfCalls + ", slidingWindowSize=" + this.slidingWindowSize + ", slowCallDurationThreshold=" + this.slowCallDurationThreshold + ", writableStackTraceEnabled=" + this.writableStackTraceEnabled + ", recordHttpStatuses=" + this.recordHttpStatuses + ", recordExceptions=" + this.recordExceptions + ")";
        }
    }
}

