/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cims.model.CreateIncident;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateIncidentRequest
extends BmcRequest<CreateIncident> {
    private CreateIncident createIncidentDetails;
    private String ocid;
    private String opcRequestId;
    private String homeregion;

    public CreateIncident getCreateIncidentDetails() {
        return this.createIncidentDetails;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    @InternalSdk
    public CreateIncident getBody$() {
        return this.createIncidentDetails;
    }

    public Builder toBuilder() {
        return new Builder().createIncidentDetails(this.createIncidentDetails).ocid(this.ocid).opcRequestId(this.opcRequestId).homeregion(this.homeregion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createIncidentDetails=").append(String.valueOf((Object)this.createIncidentDetails));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIncidentRequest)) {
            return false;
        }
        CreateIncidentRequest other = (CreateIncidentRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createIncidentDetails, (Object)other.createIncidentDetails) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.homeregion, other.homeregion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createIncidentDetails == null ? 43 : this.createIncidentDetails.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateIncidentRequest, CreateIncident> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateIncident createIncidentDetails = null;
        private String ocid = null;
        private String opcRequestId = null;
        private String homeregion = null;

        public Builder createIncidentDetails(CreateIncident createIncidentDetails) {
            this.createIncidentDetails = createIncidentDetails;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateIncidentRequest o) {
            this.createIncidentDetails(o.getCreateIncidentDetails());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.homeregion(o.getHomeregion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateIncidentRequest build() {
            CreateIncidentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateIncident body) {
            this.createIncidentDetails(body);
            return this;
        }

        public CreateIncidentRequest buildWithoutInvocationCallback() {
            CreateIncidentRequest request = new CreateIncidentRequest();
            request.createIncidentDetails = this.createIncidentDetails;
            request.ocid = this.ocid;
            request.opcRequestId = this.opcRequestId;
            request.homeregion = this.homeregion;
            return request;
        }
    }
}

