/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Contact
extends ExplicitlySetBmcModel {
    @JsonProperty(value="contactName")
    private final String contactName;
    @JsonProperty(value="contactEmail")
    private final String contactEmail;
    @JsonProperty(value="contactPhone")
    private final String contactPhone;
    @JsonProperty(value="contactType")
    private final ContactType contactType;

    @Deprecated
    @ConstructorProperties(value={"contactName", "contactEmail", "contactPhone", "contactType"})
    public Contact(String contactName, String contactEmail, String contactPhone, ContactType contactType) {
        this.contactName = contactName;
        this.contactEmail = contactEmail;
        this.contactPhone = contactPhone;
        this.contactType = contactType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public ContactType getContactType() {
        return this.contactType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Contact(");
        sb.append("super=").append(super.toString());
        sb.append("contactName=").append(String.valueOf(this.contactName));
        sb.append(", contactEmail=").append(String.valueOf(this.contactEmail));
        sb.append(", contactPhone=").append(String.valueOf(this.contactPhone));
        sb.append(", contactType=").append(String.valueOf((Object)this.contactType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)((Object)o);
        return Objects.equals(this.contactName, other.contactName) && Objects.equals(this.contactEmail, other.contactEmail) && Objects.equals(this.contactPhone, other.contactPhone) && Objects.equals((Object)this.contactType, (Object)other.contactType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.contactName == null ? 43 : this.contactName.hashCode());
        result = result * 59 + (this.contactEmail == null ? 43 : this.contactEmail.hashCode());
        result = result * 59 + (this.contactPhone == null ? 43 : this.contactPhone.hashCode());
        result = result * 59 + (this.contactType == null ? 43 : this.contactType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ContactType implements BmcEnum
    {
        Primary("PRIMARY"),
        Alternate("ALTERNATE"),
        Secondary("SECONDARY"),
        Admin("ADMIN"),
        Manager("MANAGER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContactType> map;

        private ContactType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContactType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContactType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContactType.class);
            map = new HashMap<String, ContactType>();
            for (ContactType v : ContactType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="contactName")
        private String contactName;
        @JsonProperty(value="contactEmail")
        private String contactEmail;
        @JsonProperty(value="contactPhone")
        private String contactPhone;
        @JsonProperty(value="contactType")
        private ContactType contactType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder contactName(String contactName) {
            this.contactName = contactName;
            this.__explicitlySet__.add("contactName");
            return this;
        }

        public Builder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            this.__explicitlySet__.add("contactEmail");
            return this;
        }

        public Builder contactPhone(String contactPhone) {
            this.contactPhone = contactPhone;
            this.__explicitlySet__.add("contactPhone");
            return this;
        }

        public Builder contactType(ContactType contactType) {
            this.contactType = contactType;
            this.__explicitlySet__.add("contactType");
            return this;
        }

        public Contact build() {
            Contact model = new Contact(this.contactName, this.contactEmail, this.contactPhone, this.contactType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Contact model) {
            if (model.wasPropertyExplicitlySet("contactName")) {
                this.contactName(model.getContactName());
            }
            if (model.wasPropertyExplicitlySet("contactEmail")) {
                this.contactEmail(model.getContactEmail());
            }
            if (model.wasPropertyExplicitlySet("contactPhone")) {
                this.contactPhone(model.getContactPhone());
            }
            if (model.wasPropertyExplicitlySet("contactType")) {
                this.contactType(model.getContactType());
            }
            return this;
        }
    }
}

