/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CancelCertificateVersionDeletionRequest
extends BmcRequest<Void> {
    private String certificateId;
    private Long certificateVersionNumber;
    private String opcRequestId;
    private String ifMatch;

    public String getCertificateId() {
        return this.certificateId;
    }

    public Long getCertificateVersionNumber() {
        return this.certificateVersionNumber;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().certificateId(this.certificateId).certificateVersionNumber(this.certificateVersionNumber).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateId=").append(String.valueOf(this.certificateId));
        sb.append(",certificateVersionNumber=").append(String.valueOf(this.certificateVersionNumber));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelCertificateVersionDeletionRequest)) {
            return false;
        }
        CancelCertificateVersionDeletionRequest other = (CancelCertificateVersionDeletionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.certificateVersionNumber, other.certificateVersionNumber) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.certificateVersionNumber == null ? 43 : this.certificateVersionNumber.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelCertificateVersionDeletionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateId = null;
        private Long certificateVersionNumber = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder certificateVersionNumber(Long certificateVersionNumber) {
            this.certificateVersionNumber = certificateVersionNumber;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelCertificateVersionDeletionRequest o) {
            this.certificateId(o.getCertificateId());
            this.certificateVersionNumber(o.getCertificateVersionNumber());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelCertificateVersionDeletionRequest build() {
            CancelCertificateVersionDeletionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CancelCertificateVersionDeletionRequest buildWithoutInvocationCallback() {
            CancelCertificateVersionDeletionRequest request = new CancelCertificateVersionDeletionRequest();
            request.certificateId = this.certificateId;
            request.certificateVersionNumber = this.certificateVersionNumber;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

