/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityConfigType;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityRule;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityVersionSummary;
import com.oracle.bmc.certificatesmanagement.model.CertificateRevocationListDetails;
import com.oracle.bmc.certificatesmanagement.model.CertificateSubject;
import com.oracle.bmc.certificatesmanagement.model.SignatureAlgorithm;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CertificateAuthority
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="issuerCertificateAuthorityId")
    private final String issuerCertificateAuthorityId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="lifecycleState")
    private final CertificateAuthorityLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="certificateAuthorityRules")
    private final List<CertificateAuthorityRule> certificateAuthorityRules;
    @JsonProperty(value="currentVersion")
    private final CertificateAuthorityVersionSummary currentVersion;
    @JsonProperty(value="certificateRevocationListDetails")
    private final CertificateRevocationListDetails certificateRevocationListDetails;
    @JsonProperty(value="configType")
    private final CertificateAuthorityConfigType configType;
    @JsonProperty(value="subject")
    private final CertificateSubject subject;
    @JsonProperty(value="signingAlgorithm")
    private final SignatureAlgorithm signingAlgorithm;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "issuerCertificateAuthorityId", "name", "description", "timeCreated", "timeOfDeletion", "kmsKeyId", "lifecycleState", "lifecycleDetails", "compartmentId", "certificateAuthorityRules", "currentVersion", "certificateRevocationListDetails", "configType", "subject", "signingAlgorithm", "freeformTags", "definedTags"})
    public CertificateAuthority(String id, String issuerCertificateAuthorityId, String name, String description, Date timeCreated, Date timeOfDeletion, String kmsKeyId, CertificateAuthorityLifecycleState lifecycleState, String lifecycleDetails, String compartmentId, List<CertificateAuthorityRule> certificateAuthorityRules, CertificateAuthorityVersionSummary currentVersion, CertificateRevocationListDetails certificateRevocationListDetails, CertificateAuthorityConfigType configType, CertificateSubject subject, SignatureAlgorithm signingAlgorithm, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
        this.name = name;
        this.description = description;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.kmsKeyId = kmsKeyId;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.compartmentId = compartmentId;
        this.certificateAuthorityRules = certificateAuthorityRules;
        this.currentVersion = currentVersion;
        this.certificateRevocationListDetails = certificateRevocationListDetails;
        this.configType = configType;
        this.subject = subject;
        this.signingAlgorithm = signingAlgorithm;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getIssuerCertificateAuthorityId() {
        return this.issuerCertificateAuthorityId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CertificateAuthorityLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<CertificateAuthorityRule> getCertificateAuthorityRules() {
        return this.certificateAuthorityRules;
    }

    public CertificateAuthorityVersionSummary getCurrentVersion() {
        return this.currentVersion;
    }

    public CertificateRevocationListDetails getCertificateRevocationListDetails() {
        return this.certificateRevocationListDetails;
    }

    public CertificateAuthorityConfigType getConfigType() {
        return this.configType;
    }

    public CertificateSubject getSubject() {
        return this.subject;
    }

    public SignatureAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateAuthority(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", issuerCertificateAuthorityId=").append(String.valueOf(this.issuerCertificateAuthorityId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", certificateAuthorityRules=").append(String.valueOf(this.certificateAuthorityRules));
        sb.append(", currentVersion=").append(String.valueOf((Object)this.currentVersion));
        sb.append(", certificateRevocationListDetails=").append(String.valueOf((Object)this.certificateRevocationListDetails));
        sb.append(", configType=").append(String.valueOf((Object)this.configType));
        sb.append(", subject=").append(String.valueOf((Object)this.subject));
        sb.append(", signingAlgorithm=").append(String.valueOf((Object)this.signingAlgorithm));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateAuthority)) {
            return false;
        }
        CertificateAuthority other = (CertificateAuthority)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.issuerCertificateAuthorityId, other.issuerCertificateAuthorityId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.certificateAuthorityRules, other.certificateAuthorityRules) && Objects.equals((Object)this.currentVersion, (Object)other.currentVersion) && Objects.equals((Object)this.certificateRevocationListDetails, (Object)other.certificateRevocationListDetails) && Objects.equals((Object)this.configType, (Object)other.configType) && Objects.equals((Object)this.subject, (Object)other.subject) && Objects.equals((Object)this.signingAlgorithm, (Object)other.signingAlgorithm) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.issuerCertificateAuthorityId == null ? 43 : this.issuerCertificateAuthorityId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.certificateAuthorityRules == null ? 43 : this.certificateAuthorityRules.hashCode());
        result = result * 59 + (this.currentVersion == null ? 43 : this.currentVersion.hashCode());
        result = result * 59 + (this.certificateRevocationListDetails == null ? 43 : this.certificateRevocationListDetails.hashCode());
        result = result * 59 + (this.configType == null ? 43 : this.configType.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.signingAlgorithm == null ? 43 : this.signingAlgorithm.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="issuerCertificateAuthorityId")
        private String issuerCertificateAuthorityId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="lifecycleState")
        private CertificateAuthorityLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="certificateAuthorityRules")
        private List<CertificateAuthorityRule> certificateAuthorityRules;
        @JsonProperty(value="currentVersion")
        private CertificateAuthorityVersionSummary currentVersion;
        @JsonProperty(value="certificateRevocationListDetails")
        private CertificateRevocationListDetails certificateRevocationListDetails;
        @JsonProperty(value="configType")
        private CertificateAuthorityConfigType configType;
        @JsonProperty(value="subject")
        private CertificateSubject subject;
        @JsonProperty(value="signingAlgorithm")
        private SignatureAlgorithm signingAlgorithm;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder issuerCertificateAuthorityId(String issuerCertificateAuthorityId) {
            this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
            this.__explicitlySet__.add("issuerCertificateAuthorityId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder lifecycleState(CertificateAuthorityLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder certificateAuthorityRules(List<CertificateAuthorityRule> certificateAuthorityRules) {
            this.certificateAuthorityRules = certificateAuthorityRules;
            this.__explicitlySet__.add("certificateAuthorityRules");
            return this;
        }

        public Builder currentVersion(CertificateAuthorityVersionSummary currentVersion) {
            this.currentVersion = currentVersion;
            this.__explicitlySet__.add("currentVersion");
            return this;
        }

        public Builder certificateRevocationListDetails(CertificateRevocationListDetails certificateRevocationListDetails) {
            this.certificateRevocationListDetails = certificateRevocationListDetails;
            this.__explicitlySet__.add("certificateRevocationListDetails");
            return this;
        }

        public Builder configType(CertificateAuthorityConfigType configType) {
            this.configType = configType;
            this.__explicitlySet__.add("configType");
            return this;
        }

        public Builder subject(CertificateSubject subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder signingAlgorithm(SignatureAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            this.__explicitlySet__.add("signingAlgorithm");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CertificateAuthority build() {
            CertificateAuthority model = new CertificateAuthority(this.id, this.issuerCertificateAuthorityId, this.name, this.description, this.timeCreated, this.timeOfDeletion, this.kmsKeyId, this.lifecycleState, this.lifecycleDetails, this.compartmentId, this.certificateAuthorityRules, this.currentVersion, this.certificateRevocationListDetails, this.configType, this.subject, this.signingAlgorithm, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateAuthority model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("issuerCertificateAuthorityId")) {
                this.issuerCertificateAuthorityId(model.getIssuerCertificateAuthorityId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("certificateAuthorityRules")) {
                this.certificateAuthorityRules(model.getCertificateAuthorityRules());
            }
            if (model.wasPropertyExplicitlySet("currentVersion")) {
                this.currentVersion(model.getCurrentVersion());
            }
            if (model.wasPropertyExplicitlySet("certificateRevocationListDetails")) {
                this.certificateRevocationListDetails(model.getCertificateRevocationListDetails());
            }
            if (model.wasPropertyExplicitlySet("configType")) {
                this.configType(model.getConfigType());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("signingAlgorithm")) {
                this.signingAlgorithm(model.getSigningAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

