/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.bds.model.CreateNodeDetails;
import com.oracle.bmc.bds.model.NetworkConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateBdsInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="clusterVersion")
    private final BdsInstance.ClusterVersion clusterVersion;
    @JsonProperty(value="clusterPublicKey")
    private final String clusterPublicKey;
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;
    @JsonProperty(value="isHighAvailability")
    private final Boolean isHighAvailability;
    @JsonProperty(value="isSecure")
    private final Boolean isSecure;
    @JsonProperty(value="networkConfig")
    private final NetworkConfig networkConfig;
    @JsonProperty(value="bootstrapScriptUrl")
    private final String bootstrapScriptUrl;
    @JsonProperty(value="nodes")
    private final List<CreateNodeDetails> nodes;
    @JsonProperty(value="kerberosRealmName")
    private final String kerberosRealmName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "clusterVersion", "clusterPublicKey", "clusterAdminPassword", "isHighAvailability", "isSecure", "networkConfig", "bootstrapScriptUrl", "nodes", "kerberosRealmName", "freeformTags", "definedTags", "kmsKeyId"})
    public CreateBdsInstanceDetails(String compartmentId, String displayName, BdsInstance.ClusterVersion clusterVersion, String clusterPublicKey, String clusterAdminPassword, Boolean isHighAvailability, Boolean isSecure, NetworkConfig networkConfig, String bootstrapScriptUrl, List<CreateNodeDetails> nodes, String kerberosRealmName, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String kmsKeyId) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.clusterVersion = clusterVersion;
        this.clusterPublicKey = clusterPublicKey;
        this.clusterAdminPassword = clusterAdminPassword;
        this.isHighAvailability = isHighAvailability;
        this.isSecure = isSecure;
        this.networkConfig = networkConfig;
        this.bootstrapScriptUrl = bootstrapScriptUrl;
        this.nodes = nodes;
        this.kerberosRealmName = kerberosRealmName;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.kmsKeyId = kmsKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BdsInstance.ClusterVersion getClusterVersion() {
        return this.clusterVersion;
    }

    public String getClusterPublicKey() {
        return this.clusterPublicKey;
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public Boolean getIsHighAvailability() {
        return this.isHighAvailability;
    }

    public Boolean getIsSecure() {
        return this.isSecure;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public String getBootstrapScriptUrl() {
        return this.bootstrapScriptUrl;
    }

    public List<CreateNodeDetails> getNodes() {
        return this.nodes;
    }

    public String getKerberosRealmName() {
        return this.kerberosRealmName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBdsInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", clusterVersion=").append(String.valueOf((Object)this.clusterVersion));
        sb.append(", clusterPublicKey=").append(String.valueOf(this.clusterPublicKey));
        sb.append(", clusterAdminPassword=").append("<redacted>");
        sb.append(", isHighAvailability=").append(String.valueOf(this.isHighAvailability));
        sb.append(", isSecure=").append(String.valueOf(this.isSecure));
        sb.append(", networkConfig=").append(String.valueOf((Object)this.networkConfig));
        sb.append(", bootstrapScriptUrl=").append(String.valueOf(this.bootstrapScriptUrl));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", kerberosRealmName=").append(String.valueOf(this.kerberosRealmName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBdsInstanceDetails)) {
            return false;
        }
        CreateBdsInstanceDetails other = (CreateBdsInstanceDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.clusterVersion, (Object)other.clusterVersion) && Objects.equals(this.clusterPublicKey, other.clusterPublicKey) && Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && Objects.equals(this.isHighAvailability, other.isHighAvailability) && Objects.equals(this.isSecure, other.isSecure) && Objects.equals((Object)this.networkConfig, (Object)other.networkConfig) && Objects.equals(this.bootstrapScriptUrl, other.bootstrapScriptUrl) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.kerberosRealmName, other.kerberosRealmName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.clusterVersion == null ? 43 : this.clusterVersion.hashCode());
        result = result * 59 + (this.clusterPublicKey == null ? 43 : this.clusterPublicKey.hashCode());
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + (this.isHighAvailability == null ? 43 : this.isHighAvailability.hashCode());
        result = result * 59 + (this.isSecure == null ? 43 : this.isSecure.hashCode());
        result = result * 59 + (this.networkConfig == null ? 43 : this.networkConfig.hashCode());
        result = result * 59 + (this.bootstrapScriptUrl == null ? 43 : this.bootstrapScriptUrl.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.kerberosRealmName == null ? 43 : this.kerberosRealmName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="clusterVersion")
        private BdsInstance.ClusterVersion clusterVersion;
        @JsonProperty(value="clusterPublicKey")
        private String clusterPublicKey;
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonProperty(value="isHighAvailability")
        private Boolean isHighAvailability;
        @JsonProperty(value="isSecure")
        private Boolean isSecure;
        @JsonProperty(value="networkConfig")
        private NetworkConfig networkConfig;
        @JsonProperty(value="bootstrapScriptUrl")
        private String bootstrapScriptUrl;
        @JsonProperty(value="nodes")
        private List<CreateNodeDetails> nodes;
        @JsonProperty(value="kerberosRealmName")
        private String kerberosRealmName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder clusterVersion(BdsInstance.ClusterVersion clusterVersion) {
            this.clusterVersion = clusterVersion;
            this.__explicitlySet__.add("clusterVersion");
            return this;
        }

        public Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            this.__explicitlySet__.add("clusterPublicKey");
            return this;
        }

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public Builder isHighAvailability(Boolean isHighAvailability) {
            this.isHighAvailability = isHighAvailability;
            this.__explicitlySet__.add("isHighAvailability");
            return this;
        }

        public Builder isSecure(Boolean isSecure) {
            this.isSecure = isSecure;
            this.__explicitlySet__.add("isSecure");
            return this;
        }

        public Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            this.__explicitlySet__.add("networkConfig");
            return this;
        }

        public Builder bootstrapScriptUrl(String bootstrapScriptUrl) {
            this.bootstrapScriptUrl = bootstrapScriptUrl;
            this.__explicitlySet__.add("bootstrapScriptUrl");
            return this;
        }

        public Builder nodes(List<CreateNodeDetails> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder kerberosRealmName(String kerberosRealmName) {
            this.kerberosRealmName = kerberosRealmName;
            this.__explicitlySet__.add("kerberosRealmName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public CreateBdsInstanceDetails build() {
            CreateBdsInstanceDetails model = new CreateBdsInstanceDetails(this.compartmentId, this.displayName, this.clusterVersion, this.clusterPublicKey, this.clusterAdminPassword, this.isHighAvailability, this.isSecure, this.networkConfig, this.bootstrapScriptUrl, this.nodes, this.kerberosRealmName, this.freeformTags, this.definedTags, this.kmsKeyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBdsInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("clusterVersion")) {
                this.clusterVersion(model.getClusterVersion());
            }
            if (model.wasPropertyExplicitlySet("clusterPublicKey")) {
                this.clusterPublicKey(model.getClusterPublicKey());
            }
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("isHighAvailability")) {
                this.isHighAvailability(model.getIsHighAvailability());
            }
            if (model.wasPropertyExplicitlySet("isSecure")) {
                this.isSecure(model.getIsSecure());
            }
            if (model.wasPropertyExplicitlySet("networkConfig")) {
                this.networkConfig(model.getNetworkConfig());
            }
            if (model.wasPropertyExplicitlySet("bootstrapScriptUrl")) {
                this.bootstrapScriptUrl(model.getBootstrapScriptUrl());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("kerberosRealmName")) {
                this.kerberosRealmName(model.getKerberosRealmName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            return this;
        }
    }
}

