/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.KerberosDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudSqlDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="blockVolumeSizeInGBs")
    private final Long blockVolumeSizeInGBs;
    @JsonProperty(value="isKerberosMappedToDatabaseUsers")
    private final Boolean isKerberosMappedToDatabaseUsers;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="kerberosDetails")
    private final List<KerberosDetails> kerberosDetails;

    @Deprecated
    @ConstructorProperties(value={"shape", "blockVolumeSizeInGBs", "isKerberosMappedToDatabaseUsers", "ipAddress", "kerberosDetails"})
    public CloudSqlDetails(String shape, Long blockVolumeSizeInGBs, Boolean isKerberosMappedToDatabaseUsers, String ipAddress, List<KerberosDetails> kerberosDetails) {
        this.shape = shape;
        this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
        this.isKerberosMappedToDatabaseUsers = isKerberosMappedToDatabaseUsers;
        this.ipAddress = ipAddress;
        this.kerberosDetails = kerberosDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public Long getBlockVolumeSizeInGBs() {
        return this.blockVolumeSizeInGBs;
    }

    public Boolean getIsKerberosMappedToDatabaseUsers() {
        return this.isKerberosMappedToDatabaseUsers;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public List<KerberosDetails> getKerberosDetails() {
        return this.kerberosDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloudSqlDetails(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", blockVolumeSizeInGBs=").append(String.valueOf(this.blockVolumeSizeInGBs));
        sb.append(", isKerberosMappedToDatabaseUsers=").append(String.valueOf(this.isKerberosMappedToDatabaseUsers));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", kerberosDetails=").append(String.valueOf(this.kerberosDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudSqlDetails)) {
            return false;
        }
        CloudSqlDetails other = (CloudSqlDetails)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals(this.blockVolumeSizeInGBs, other.blockVolumeSizeInGBs) && Objects.equals(this.isKerberosMappedToDatabaseUsers, other.isKerberosMappedToDatabaseUsers) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.kerberosDetails, other.kerberosDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.blockVolumeSizeInGBs == null ? 43 : this.blockVolumeSizeInGBs.hashCode());
        result = result * 59 + (this.isKerberosMappedToDatabaseUsers == null ? 43 : this.isKerberosMappedToDatabaseUsers.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.kerberosDetails == null ? 43 : this.kerberosDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="blockVolumeSizeInGBs")
        private Long blockVolumeSizeInGBs;
        @JsonProperty(value="isKerberosMappedToDatabaseUsers")
        private Boolean isKerberosMappedToDatabaseUsers;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="kerberosDetails")
        private List<KerberosDetails> kerberosDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder blockVolumeSizeInGBs(Long blockVolumeSizeInGBs) {
            this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
            this.__explicitlySet__.add("blockVolumeSizeInGBs");
            return this;
        }

        public Builder isKerberosMappedToDatabaseUsers(Boolean isKerberosMappedToDatabaseUsers) {
            this.isKerberosMappedToDatabaseUsers = isKerberosMappedToDatabaseUsers;
            this.__explicitlySet__.add("isKerberosMappedToDatabaseUsers");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder kerberosDetails(List<KerberosDetails> kerberosDetails) {
            this.kerberosDetails = kerberosDetails;
            this.__explicitlySet__.add("kerberosDetails");
            return this;
        }

        public CloudSqlDetails build() {
            CloudSqlDetails model = new CloudSqlDetails(this.shape, this.blockVolumeSizeInGBs, this.isKerberosMappedToDatabaseUsers, this.ipAddress, this.kerberosDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloudSqlDetails model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeSizeInGBs")) {
                this.blockVolumeSizeInGBs(model.getBlockVolumeSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("isKerberosMappedToDatabaseUsers")) {
                this.isKerberosMappedToDatabaseUsers(model.getIsKerberosMappedToDatabaseUsers());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("kerberosDetails")) {
                this.kerberosDetails(model.getKerberosDetails());
            }
            return this;
        }
    }
}

