/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.BdsAsyncClient;
import com.oracle.bmc.bds.BdsPaginators;
import com.oracle.bmc.bds.BdsWaiters;
import com.oracle.bmc.bds.model.AutoScalingConfiguration;
import com.oracle.bmc.bds.model.AutoScalingConfigurationSummary;
import com.oracle.bmc.bds.model.BdsApiKey;
import com.oracle.bmc.bds.model.BdsApiKeySummary;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.bds.model.BdsInstanceSummary;
import com.oracle.bmc.bds.model.BdsMetastoreConfiguration;
import com.oracle.bmc.bds.model.BdsMetastoreConfigurationSummary;
import com.oracle.bmc.bds.model.PatchHistorySummary;
import com.oracle.bmc.bds.model.PatchSummary;
import com.oracle.bmc.bds.model.WorkRequest;
import com.oracle.bmc.bds.model.WorkRequestError;
import com.oracle.bmc.bds.model.WorkRequestLogEntry;
import com.oracle.bmc.bds.requests.ActivateBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.AddAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.AddBlockStorageRequest;
import com.oracle.bmc.bds.requests.AddCloudSqlRequest;
import com.oracle.bmc.bds.requests.AddWorkerNodesRequest;
import com.oracle.bmc.bds.requests.ChangeBdsInstanceCompartmentRequest;
import com.oracle.bmc.bds.requests.ChangeShapeRequest;
import com.oracle.bmc.bds.requests.CreateBdsApiKeyRequest;
import com.oracle.bmc.bds.requests.CreateBdsInstanceRequest;
import com.oracle.bmc.bds.requests.CreateBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.DeleteBdsApiKeyRequest;
import com.oracle.bmc.bds.requests.DeleteBdsInstanceRequest;
import com.oracle.bmc.bds.requests.DeleteBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsApiKeyRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.requests.InstallPatchRequest;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsApiKeysRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListBdsMetastoreConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListPatchHistoriesRequest;
import com.oracle.bmc.bds.requests.ListPatchesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.requests.RemoveAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.RemoveCloudSqlRequest;
import com.oracle.bmc.bds.requests.RemoveNodeRequest;
import com.oracle.bmc.bds.requests.RestartNodeRequest;
import com.oracle.bmc.bds.requests.StartBdsInstanceRequest;
import com.oracle.bmc.bds.requests.StopBdsInstanceRequest;
import com.oracle.bmc.bds.requests.TestBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.TestBdsObjectStorageConnectionRequest;
import com.oracle.bmc.bds.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.UpdateBdsInstanceRequest;
import com.oracle.bmc.bds.requests.UpdateBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.responses.ActivateBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.AddAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.AddBlockStorageResponse;
import com.oracle.bmc.bds.responses.AddCloudSqlResponse;
import com.oracle.bmc.bds.responses.AddWorkerNodesResponse;
import com.oracle.bmc.bds.responses.ChangeBdsInstanceCompartmentResponse;
import com.oracle.bmc.bds.responses.ChangeShapeResponse;
import com.oracle.bmc.bds.responses.CreateBdsApiKeyResponse;
import com.oracle.bmc.bds.responses.CreateBdsInstanceResponse;
import com.oracle.bmc.bds.responses.CreateBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.DeleteBdsApiKeyResponse;
import com.oracle.bmc.bds.responses.DeleteBdsInstanceResponse;
import com.oracle.bmc.bds.responses.DeleteBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsApiKeyResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.bds.responses.InstallPatchResponse;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsApiKeysResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListBdsMetastoreConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListPatchHistoriesResponse;
import com.oracle.bmc.bds.responses.ListPatchesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bds.responses.RemoveAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.RemoveCloudSqlResponse;
import com.oracle.bmc.bds.responses.RemoveNodeResponse;
import com.oracle.bmc.bds.responses.RestartNodeResponse;
import com.oracle.bmc.bds.responses.StartBdsInstanceResponse;
import com.oracle.bmc.bds.responses.StopBdsInstanceResponse;
import com.oracle.bmc.bds.responses.TestBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.TestBdsObjectStorageConnectionResponse;
import com.oracle.bmc.bds.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.UpdateBdsInstanceResponse;
import com.oracle.bmc.bds.responses.UpdateBdsMetastoreConfigurationResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdsClient
extends BaseSyncClient
implements Bds {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BDS").serviceEndpointPrefix("").serviceEndpointTemplate("https://bigdataservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BdsAsyncClient.class);
    private final BdsWaiters waiters;
    private final BdsPaginators paginators;

    private BdsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Bds-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BdsWaiters(executorService, this);
        this.paginators = new BdsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateBdsMetastoreConfigurationResponse activateBdsMetastoreConfiguration(ActivateBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMetastoreConfigId(), (String)"metastoreConfigId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getActivateBdsMetastoreConfigurationDetails(), "activateBdsMetastoreConfigurationDetails is required");
        return (ActivateBdsMetastoreConfigurationResponse)this.clientCall(request, ActivateBdsMetastoreConfigurationResponse::builder).logger(LOG, "activateBdsMetastoreConfiguration").serviceDetails("Bds", "ActivateBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/ActivateBdsMetastoreConfiguration").method(Method.POST).requestBuilder(ActivateBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendPathParam(request.getMetastoreConfigId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ActivateBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ActivateBdsMetastoreConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddAutoScalingConfigurationResponse addAutoScalingConfiguration(AddAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddAutoScalingConfigurationDetails(), "addAutoScalingConfigurationDetails is required");
        return (AddAutoScalingConfigurationResponse)this.clientCall(request, AddAutoScalingConfigurationResponse::builder).logger(LOG, "addAutoScalingConfiguration").serviceDetails("Bds", "AddAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/AddAutoScalingConfiguration").method(Method.POST).requestBuilder(AddAutoScalingConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("autoScalingConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddAutoScalingConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddAutoScalingConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddBlockStorageResponse addBlockStorage(AddBlockStorageRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddBlockStorageDetails(), "addBlockStorageDetails is required");
        return (AddBlockStorageResponse)this.clientCall(request, AddBlockStorageResponse::builder).logger(LOG, "addBlockStorage").serviceDetails("Bds", "AddBlockStorage", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/AddBlockStorage").method(Method.POST).requestBuilder(AddBlockStorageRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("addBlockStorage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddBlockStorageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddBlockStorageResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddCloudSqlResponse addCloudSql(AddCloudSqlRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddCloudSqlDetails(), "addCloudSqlDetails is required");
        return (AddCloudSqlResponse)this.clientCall(request, AddCloudSqlResponse::builder).logger(LOG, "addCloudSql").serviceDetails("Bds", "AddCloudSql", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/AddCloudSql").method(Method.POST).requestBuilder(AddCloudSqlRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("addCloudSql").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddCloudSqlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddCloudSqlResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddWorkerNodesResponse addWorkerNodes(AddWorkerNodesRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddWorkerNodesDetails(), "addWorkerNodesDetails is required");
        return (AddWorkerNodesResponse)this.clientCall(request, AddWorkerNodesResponse::builder).logger(LOG, "addWorkerNodes").serviceDetails("Bds", "AddWorkerNodes", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/AddWorkerNodes").method(Method.POST).requestBuilder(AddWorkerNodesRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("addWorkerNodes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddWorkerNodesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddWorkerNodesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeBdsInstanceCompartmentResponse changeBdsInstanceCompartment(ChangeBdsInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBdsInstanceCompartmentDetails(), "changeBdsInstanceCompartmentDetails is required");
        return (ChangeBdsInstanceCompartmentResponse)this.clientCall(request, ChangeBdsInstanceCompartmentResponse::builder).logger(LOG, "changeBdsInstanceCompartment").serviceDetails("Bds", "ChangeBdsInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/ChangeBdsInstanceCompartment").method(Method.POST).requestBuilder(ChangeBdsInstanceCompartmentRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeBdsInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeBdsInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeShapeResponse changeShape(ChangeShapeRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeShapeDetails(), "changeShapeDetails is required");
        return (ChangeShapeResponse)this.clientCall(request, ChangeShapeResponse::builder).logger(LOG, "changeShape").serviceDetails("Bds", "ChangeShape", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/ChangeShape").method(Method.POST).requestBuilder(ChangeShapeRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("changeShape").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeShapeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeShapeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateBdsApiKeyResponse createBdsApiKey(CreateBdsApiKeyRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBdsApiKeyDetails(), "createBdsApiKeyDetails is required");
        return (CreateBdsApiKeyResponse)this.clientCall(request, CreateBdsApiKeyResponse::builder).logger(LOG, "createBdsApiKey").serviceDetails("Bds", "CreateBdsApiKey", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsApiKey/CreateBdsApiKey").method(Method.POST).requestBuilder(CreateBdsApiKeyRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("apiKeys").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateBdsApiKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateBdsApiKeyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateBdsInstanceResponse createBdsInstance(CreateBdsInstanceRequest request) {
        Objects.requireNonNull(request.getCreateBdsInstanceDetails(), "createBdsInstanceDetails is required");
        return (CreateBdsInstanceResponse)this.clientCall(request, CreateBdsInstanceResponse::builder).logger(LOG, "createBdsInstance").serviceDetails("Bds", "CreateBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/CreateBdsInstance").method(Method.POST).requestBuilder(CreateBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateBdsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateBdsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateBdsMetastoreConfigurationResponse createBdsMetastoreConfiguration(CreateBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBdsMetastoreConfigurationDetails(), "createBdsMetastoreConfigurationDetails is required");
        return (CreateBdsMetastoreConfigurationResponse)this.clientCall(request, CreateBdsMetastoreConfigurationResponse::builder).logger(LOG, "createBdsMetastoreConfiguration").serviceDetails("Bds", "CreateBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/CreateBdsMetastoreConfiguration").method(Method.POST).requestBuilder(CreateBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateBdsMetastoreConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteBdsApiKeyResponse deleteBdsApiKey(DeleteBdsApiKeyRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApiKeyId(), (String)"apiKeyId must not be blank", (Object[])new Object[0]);
        return (DeleteBdsApiKeyResponse)this.clientCall(request, DeleteBdsApiKeyResponse::builder).logger(LOG, "deleteBdsApiKey").serviceDetails("Bds", "DeleteBdsApiKey", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsApiKey/DeleteBdsApiKey").method(Method.DELETE).requestBuilder(DeleteBdsApiKeyRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("apiKeys").appendPathParam(request.getApiKeyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBdsApiKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteBdsApiKeyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteBdsInstanceResponse deleteBdsInstance(DeleteBdsInstanceRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteBdsInstanceResponse)this.clientCall(request, DeleteBdsInstanceResponse::builder).logger(LOG, "deleteBdsInstance").serviceDetails("Bds", "DeleteBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/DeleteBdsInstance").method(Method.DELETE).requestBuilder(DeleteBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBdsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteBdsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteBdsMetastoreConfigurationResponse deleteBdsMetastoreConfiguration(DeleteBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMetastoreConfigId(), (String)"metastoreConfigId must not be blank", (Object[])new Object[0]);
        return (DeleteBdsMetastoreConfigurationResponse)this.clientCall(request, DeleteBdsMetastoreConfigurationResponse::builder).logger(LOG, "deleteBdsMetastoreConfiguration").serviceDetails("Bds", "DeleteBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/DeleteBdsMetastoreConfiguration").method(Method.DELETE).requestBuilder(DeleteBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendPathParam(request.getMetastoreConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteBdsMetastoreConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetAutoScalingConfigurationResponse getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        return (GetAutoScalingConfigurationResponse)this.clientCall(request, GetAutoScalingConfigurationResponse::builder).logger(LOG, "getAutoScalingConfiguration").serviceDetails("Bds", "GetAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/GetAutoScalingConfiguration").method(Method.GET).requestBuilder(GetAutoScalingConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("autoScalingConfiguration").appendPathParam(request.getAutoScalingConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoScalingConfiguration.class, GetAutoScalingConfigurationResponse.Builder::autoScalingConfiguration).handleResponseHeaderString("opc-request-id", GetAutoScalingConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAutoScalingConfigurationResponse.Builder::etag).callSync();
    }

    @Override
    public GetBdsApiKeyResponse getBdsApiKey(GetBdsApiKeyRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApiKeyId(), (String)"apiKeyId must not be blank", (Object[])new Object[0]);
        return (GetBdsApiKeyResponse)this.clientCall(request, GetBdsApiKeyResponse::builder).logger(LOG, "getBdsApiKey").serviceDetails("Bds", "GetBdsApiKey", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsApiKey/GetBdsApiKey").method(Method.GET).requestBuilder(GetBdsApiKeyRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("apiKeys").appendPathParam(request.getApiKeyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BdsApiKey.class, GetBdsApiKeyResponse.Builder::bdsApiKey).handleResponseHeaderString("opc-request-id", GetBdsApiKeyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBdsApiKeyResponse.Builder::etag).callSync();
    }

    @Override
    public GetBdsInstanceResponse getBdsInstance(GetBdsInstanceRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (GetBdsInstanceResponse)this.clientCall(request, GetBdsInstanceResponse::builder).logger(LOG, "getBdsInstance").serviceDetails("Bds", "GetBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/GetBdsInstance").method(Method.GET).requestBuilder(GetBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BdsInstance.class, GetBdsInstanceResponse.Builder::bdsInstance).handleResponseHeaderString("opc-request-id", GetBdsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBdsInstanceResponse.Builder::etag).callSync();
    }

    @Override
    public GetBdsMetastoreConfigurationResponse getBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMetastoreConfigId(), (String)"metastoreConfigId must not be blank", (Object[])new Object[0]);
        return (GetBdsMetastoreConfigurationResponse)this.clientCall(request, GetBdsMetastoreConfigurationResponse::builder).logger(LOG, "getBdsMetastoreConfiguration").serviceDetails("Bds", "GetBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/GetBdsMetastoreConfiguration").method(Method.GET).requestBuilder(GetBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendPathParam(request.getMetastoreConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BdsMetastoreConfiguration.class, GetBdsMetastoreConfigurationResponse.Builder::bdsMetastoreConfiguration).handleResponseHeaderString("opc-request-id", GetBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBdsMetastoreConfigurationResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Bds", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderBigDecimal("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public InstallPatchResponse installPatch(InstallPatchRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallPatchDetails(), "installPatchDetails is required");
        return (InstallPatchResponse)this.clientCall(request, InstallPatchResponse::builder).logger(LOG, "installPatch").serviceDetails("Bds", "InstallPatch", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/InstallPatch").method(Method.POST).requestBuilder(InstallPatchRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("installPatch").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", InstallPatchResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", InstallPatchResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ListAutoScalingConfigurationsResponse listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (ListAutoScalingConfigurationsResponse)this.clientCall(request, ListAutoScalingConfigurationsResponse::builder).logger(LOG, "listAutoScalingConfigurations").serviceDetails("Bds", "ListAutoScalingConfigurations", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/ListAutoScalingConfigurations").method(Method.GET).requestBuilder(ListAutoScalingConfigurationsRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("autoScalingConfiguration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AutoScalingConfigurationSummary.class, ListAutoScalingConfigurationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAutoScalingConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAutoScalingConfigurationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBdsApiKeysResponse listBdsApiKeys(ListBdsApiKeysRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (ListBdsApiKeysResponse)this.clientCall(request, ListBdsApiKeysResponse::builder).logger(LOG, "listBdsApiKeys").serviceDetails("Bds", "ListBdsApiKeys", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsApiKey/ListBdsApiKeys").method(Method.GET).requestBuilder(ListBdsApiKeysRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("apiKeys").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("userId", (Object)request.getUserId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BdsApiKeySummary.class, ListBdsApiKeysResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBdsApiKeysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBdsApiKeysResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBdsInstancesResponse listBdsInstances(ListBdsInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBdsInstancesResponse)this.clientCall(request, ListBdsInstancesResponse::builder).logger(LOG, "listBdsInstances").serviceDetails("Bds", "ListBdsInstances", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstanceSummary/ListBdsInstances").method(Method.GET).requestBuilder(ListBdsInstancesRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BdsInstanceSummary.class, ListBdsInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBdsInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBdsInstancesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBdsMetastoreConfigurationsResponse listBdsMetastoreConfigurations(ListBdsMetastoreConfigurationsRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (ListBdsMetastoreConfigurationsResponse)this.clientCall(request, ListBdsMetastoreConfigurationsResponse::builder).logger(LOG, "listBdsMetastoreConfigurations").serviceDetails("Bds", "ListBdsMetastoreConfigurations", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/ListBdsMetastoreConfigurations").method(Method.GET).requestBuilder(ListBdsMetastoreConfigurationsRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendEnumQueryParam("metastoreType", (BmcEnum)request.getMetastoreType()).appendQueryParam("metastoreId", (Object)request.getMetastoreId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("bdsApiKeyId", (Object)request.getBdsApiKeyId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BdsMetastoreConfigurationSummary.class, ListBdsMetastoreConfigurationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBdsMetastoreConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBdsMetastoreConfigurationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPatchHistoriesResponse listPatchHistories(ListPatchHistoriesRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (ListPatchHistoriesResponse)this.clientCall(request, ListPatchHistoriesResponse::builder).logger(LOG, "listPatchHistories").serviceDetails("Bds", "ListPatchHistories", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/ListPatchHistories").method(Method.GET).requestBuilder(ListPatchHistoriesRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("patchHistory").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("patchVersion", (Object)request.getPatchVersion()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PatchHistorySummary.class, ListPatchHistoriesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPatchHistoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPatchHistoriesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPatchesResponse listPatches(ListPatchesRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        return (ListPatchesResponse)this.clientCall(request, ListPatchesResponse::builder).logger(LOG, "listPatches").serviceDetails("Bds", "ListPatches", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/ListPatches").method(Method.GET).requestBuilder(ListPatchesRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("patches").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PatchSummary.class, ListPatchesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPatchesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPatchesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Bds", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Bds", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Bds", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190531").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveAutoScalingConfigurationResponse removeAutoScalingConfiguration(RemoveAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveAutoScalingConfigurationDetails(), "removeAutoScalingConfigurationDetails is required");
        return (RemoveAutoScalingConfigurationResponse)this.clientCall(request, RemoveAutoScalingConfigurationResponse::builder).logger(LOG, "removeAutoScalingConfiguration").serviceDetails("Bds", "RemoveAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/RemoveAutoScalingConfiguration").method(Method.POST).requestBuilder(RemoveAutoScalingConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("autoScalingConfiguration").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("actions").appendPathParam("remove").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RemoveAutoScalingConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveAutoScalingConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RemoveCloudSqlResponse removeCloudSql(RemoveCloudSqlRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveCloudSqlDetails(), "removeCloudSqlDetails is required");
        return (RemoveCloudSqlResponse)this.clientCall(request, RemoveCloudSqlResponse::builder).logger(LOG, "removeCloudSql").serviceDetails("Bds", "RemoveCloudSql", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/RemoveCloudSql").method(Method.POST).requestBuilder(RemoveCloudSqlRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("removeCloudSql").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RemoveCloudSqlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveCloudSqlResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RemoveNodeResponse removeNode(RemoveNodeRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveNodeDetails(), "removeNodeDetails is required");
        return (RemoveNodeResponse)this.clientCall(request, RemoveNodeResponse::builder).logger(LOG, "removeNode").serviceDetails("Bds", "RemoveNode", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/RemoveNode").method(Method.POST).requestBuilder(RemoveNodeRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("removeNode").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", RemoveNodeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveNodeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RestartNodeResponse restartNode(RestartNodeRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestartNodeDetails(), "restartNodeDetails is required");
        return (RestartNodeResponse)this.clientCall(request, RestartNodeResponse::builder).logger(LOG, "restartNode").serviceDetails("Bds", "RestartNode", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/RestartNode").method(Method.POST).requestBuilder(RestartNodeRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("restartNode").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RestartNodeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartNodeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartBdsInstanceResponse startBdsInstance(StartBdsInstanceRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartBdsInstanceDetails(), "startBdsInstanceDetails is required");
        return (StartBdsInstanceResponse)this.clientCall(request, StartBdsInstanceResponse::builder).logger(LOG, "startBdsInstance").serviceDetails("Bds", "StartBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/StartBdsInstance").method(Method.POST).requestBuilder(StartBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", StartBdsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartBdsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopBdsInstanceResponse stopBdsInstance(StopBdsInstanceRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopBdsInstanceDetails(), "stopBdsInstanceDetails is required");
        return (StopBdsInstanceResponse)this.clientCall(request, StopBdsInstanceResponse::builder).logger(LOG, "stopBdsInstance").serviceDetails("Bds", "StopBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/StopBdsInstance").method(Method.POST).requestBuilder(StopBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", StopBdsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopBdsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public TestBdsMetastoreConfigurationResponse testBdsMetastoreConfiguration(TestBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMetastoreConfigId(), (String)"metastoreConfigId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestBdsMetastoreConfigurationDetails(), "testBdsMetastoreConfigurationDetails is required");
        return (TestBdsMetastoreConfigurationResponse)this.clientCall(request, TestBdsMetastoreConfigurationResponse::builder).logger(LOG, "testBdsMetastoreConfiguration").serviceDetails("Bds", "TestBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/TestBdsMetastoreConfiguration").method(Method.POST).requestBuilder(TestBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendPathParam(request.getMetastoreConfigId()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", TestBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", TestBdsMetastoreConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public TestBdsObjectStorageConnectionResponse testBdsObjectStorageConnection(TestBdsObjectStorageConnectionRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApiKeyId(), (String)"apiKeyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestBdsObjectStorageConnectionDetails(), "testBdsObjectStorageConnectionDetails is required");
        return (TestBdsObjectStorageConnectionResponse)this.clientCall(request, TestBdsObjectStorageConnectionResponse::builder).logger(LOG, "testBdsObjectStorageConnection").serviceDetails("Bds", "TestBdsObjectStorageConnection", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsApiKey/TestBdsObjectStorageConnection").method(Method.POST).requestBuilder(TestBdsObjectStorageConnectionRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("apiKeys").appendPathParam(request.getApiKeyId()).appendPathParam("actions").appendPathParam("testObjectStorageConnection").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", TestBdsObjectStorageConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", TestBdsObjectStorageConnectionResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateAutoScalingConfigurationResponse updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAutoScalingConfigurationDetails(), "updateAutoScalingConfigurationDetails is required");
        return (UpdateAutoScalingConfigurationResponse)this.clientCall(request, UpdateAutoScalingConfigurationResponse::builder).logger(LOG, "updateAutoScalingConfiguration").serviceDetails("Bds", "UpdateAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/UpdateAutoScalingConfiguration").method(Method.PUT).requestBuilder(UpdateAutoScalingConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("autoScalingConfiguration").appendPathParam(request.getAutoScalingConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateAutoScalingConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAutoScalingConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateBdsInstanceResponse updateBdsInstance(UpdateBdsInstanceRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBdsInstanceDetails(), "updateBdsInstanceDetails is required");
        return (UpdateBdsInstanceResponse)this.clientCall(request, UpdateBdsInstanceResponse::builder).logger(LOG, "updateBdsInstance").serviceDetails("Bds", "UpdateBdsInstance", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsInstance/UpdateBdsInstance").method(Method.PUT).requestBuilder(UpdateBdsInstanceRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBdsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBdsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBdsMetastoreConfigurationResponse updateBdsMetastoreConfiguration(UpdateBdsMetastoreConfigurationRequest request) {
        Validate.notBlank((String)request.getBdsInstanceId(), (String)"bdsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMetastoreConfigId(), (String)"metastoreConfigId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBdsMetastoreConfigurationDetails(), "updateBdsMetastoreConfigurationDetails is required");
        return (UpdateBdsMetastoreConfigurationResponse)this.clientCall(request, UpdateBdsMetastoreConfigurationResponse::builder).logger(LOG, "updateBdsMetastoreConfiguration").serviceDetails("Bds", "UpdateBdsMetastoreConfiguration", "https://docs.oracle.com/iaas/api/#/en/bigdata/20190531/BdsMetastoreConfiguration/UpdateBdsMetastoreConfiguration").method(Method.PUT).requestBuilder(UpdateBdsMetastoreConfigurationRequest::builder).basePath("/20190531").appendPathParam("bdsInstances").appendPathParam(request.getBdsInstanceId()).appendPathParam("metastoreConfigs").appendPathParam(request.getMetastoreConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateBdsMetastoreConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateBdsMetastoreConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public BdsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BdsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BdsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BdsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BdsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BdsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BdsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BdsClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

