/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.autoscaling.model.Capacity;
import com.oracle.bmc.autoscaling.model.ExecutionSchedule;
import com.oracle.bmc.autoscaling.model.ResourceAction;
import com.oracle.bmc.autoscaling.model.UpdateAutoScalingPolicyDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="policyType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateScheduledPolicyDetails
extends UpdateAutoScalingPolicyDetails {
    @JsonProperty(value="executionSchedule")
    private final ExecutionSchedule executionSchedule;
    @JsonProperty(value="resourceAction")
    private final ResourceAction resourceAction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateScheduledPolicyDetails(String displayName, Capacity capacity, Boolean isEnabled, ExecutionSchedule executionSchedule, ResourceAction resourceAction) {
        super(displayName, capacity, isEnabled);
        this.executionSchedule = executionSchedule;
        this.resourceAction = resourceAction;
    }

    public ExecutionSchedule getExecutionSchedule() {
        return this.executionSchedule;
    }

    public ResourceAction getResourceAction() {
        return this.resourceAction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateScheduledPolicyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", executionSchedule=").append(String.valueOf((Object)this.executionSchedule));
        sb.append(", resourceAction=").append(String.valueOf((Object)this.resourceAction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduledPolicyDetails)) {
            return false;
        }
        UpdateScheduledPolicyDetails other = (UpdateScheduledPolicyDetails)((Object)o);
        return Objects.equals((Object)this.executionSchedule, (Object)other.executionSchedule) && Objects.equals((Object)this.resourceAction, (Object)other.resourceAction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.executionSchedule == null ? 43 : this.executionSchedule.hashCode());
        result = result * 59 + (this.resourceAction == null ? 43 : this.resourceAction.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="capacity")
        private Capacity capacity;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="executionSchedule")
        private ExecutionSchedule executionSchedule;
        @JsonProperty(value="resourceAction")
        private ResourceAction resourceAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder executionSchedule(ExecutionSchedule executionSchedule) {
            this.executionSchedule = executionSchedule;
            this.__explicitlySet__.add("executionSchedule");
            return this;
        }

        public Builder resourceAction(ResourceAction resourceAction) {
            this.resourceAction = resourceAction;
            this.__explicitlySet__.add("resourceAction");
            return this;
        }

        public UpdateScheduledPolicyDetails build() {
            UpdateScheduledPolicyDetails model = new UpdateScheduledPolicyDetails(this.displayName, this.capacity, this.isEnabled, this.executionSchedule, this.resourceAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateScheduledPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("executionSchedule")) {
                this.executionSchedule(model.getExecutionSchedule());
            }
            if (model.wasPropertyExplicitlySet("resourceAction")) {
                this.resourceAction(model.getResourceAction());
            }
            return this;
        }
    }
}

