/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.artifacts.ArtifactsAsync;
import com.oracle.bmc.artifacts.model.ContainerConfiguration;
import com.oracle.bmc.artifacts.model.ContainerImage;
import com.oracle.bmc.artifacts.model.ContainerImageCollection;
import com.oracle.bmc.artifacts.model.ContainerImageSignature;
import com.oracle.bmc.artifacts.model.ContainerImageSignatureCollection;
import com.oracle.bmc.artifacts.model.ContainerRepository;
import com.oracle.bmc.artifacts.model.ContainerRepositoryCollection;
import com.oracle.bmc.artifacts.model.GenericArtifact;
import com.oracle.bmc.artifacts.model.GenericArtifactCollection;
import com.oracle.bmc.artifacts.model.Repository;
import com.oracle.bmc.artifacts.model.RepositoryCollection;
import com.oracle.bmc.artifacts.requests.ChangeContainerRepositoryCompartmentRequest;
import com.oracle.bmc.artifacts.requests.ChangeRepositoryCompartmentRequest;
import com.oracle.bmc.artifacts.requests.CreateContainerImageSignatureRequest;
import com.oracle.bmc.artifacts.requests.CreateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.CreateRepositoryRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerImageRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerImageSignatureRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.DeleteGenericArtifactByPathRequest;
import com.oracle.bmc.artifacts.requests.DeleteGenericArtifactRequest;
import com.oracle.bmc.artifacts.requests.DeleteRepositoryRequest;
import com.oracle.bmc.artifacts.requests.GetContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.GetContainerImageRequest;
import com.oracle.bmc.artifacts.requests.GetContainerImageSignatureRequest;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.GetGenericArtifactByPathRequest;
import com.oracle.bmc.artifacts.requests.GetGenericArtifactRequest;
import com.oracle.bmc.artifacts.requests.GetRepositoryRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImageSignaturesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.requests.ListGenericArtifactsRequest;
import com.oracle.bmc.artifacts.requests.ListRepositoriesRequest;
import com.oracle.bmc.artifacts.requests.RemoveContainerVersionRequest;
import com.oracle.bmc.artifacts.requests.RestoreContainerImageRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.UpdateGenericArtifactByPathRequest;
import com.oracle.bmc.artifacts.requests.UpdateGenericArtifactRequest;
import com.oracle.bmc.artifacts.requests.UpdateRepositoryRequest;
import com.oracle.bmc.artifacts.responses.ChangeContainerRepositoryCompartmentResponse;
import com.oracle.bmc.artifacts.responses.ChangeRepositoryCompartmentResponse;
import com.oracle.bmc.artifacts.responses.CreateContainerImageSignatureResponse;
import com.oracle.bmc.artifacts.responses.CreateContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.CreateRepositoryResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerImageResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerImageSignatureResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.DeleteGenericArtifactByPathResponse;
import com.oracle.bmc.artifacts.responses.DeleteGenericArtifactResponse;
import com.oracle.bmc.artifacts.responses.DeleteRepositoryResponse;
import com.oracle.bmc.artifacts.responses.GetContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.GetContainerImageResponse;
import com.oracle.bmc.artifacts.responses.GetContainerImageSignatureResponse;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.GetGenericArtifactByPathResponse;
import com.oracle.bmc.artifacts.responses.GetGenericArtifactResponse;
import com.oracle.bmc.artifacts.responses.GetRepositoryResponse;
import com.oracle.bmc.artifacts.responses.ListContainerImageSignaturesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerRepositoriesResponse;
import com.oracle.bmc.artifacts.responses.ListGenericArtifactsResponse;
import com.oracle.bmc.artifacts.responses.ListRepositoriesResponse;
import com.oracle.bmc.artifacts.responses.RemoveContainerVersionResponse;
import com.oracle.bmc.artifacts.responses.RestoreContainerImageResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.UpdateGenericArtifactByPathResponse;
import com.oracle.bmc.artifacts.responses.UpdateGenericArtifactResponse;
import com.oracle.bmc.artifacts.responses.UpdateRepositoryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactsAsyncClient
extends BaseAsyncClient
implements ArtifactsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ARTIFACTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://artifacts.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactsAsyncClient.class);

    private ArtifactsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeContainerRepositoryCompartmentResponse> changeContainerRepositoryCompartment(ChangeContainerRepositoryCompartmentRequest request, AsyncHandler<ChangeContainerRepositoryCompartmentRequest, ChangeContainerRepositoryCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerRepositoryCompartmentDetails(), "changeContainerRepositoryCompartmentDetails is required");
        return this.clientCall(request, ChangeContainerRepositoryCompartmentResponse::builder).logger(LOG, "changeContainerRepositoryCompartment").serviceDetails("Artifacts", "ChangeContainerRepositoryCompartment", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/ChangeContainerRepositoryCompartment").method(Method.POST).requestBuilder(ChangeContainerRepositoryCompartmentRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeContainerRepositoryCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeRepositoryCompartmentResponse> changeRepositoryCompartment(ChangeRepositoryCompartmentRequest request, AsyncHandler<ChangeRepositoryCompartmentRequest, ChangeRepositoryCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRepositoryCompartmentDetails(), "changeRepositoryCompartmentDetails is required");
        return this.clientCall(request, ChangeRepositoryCompartmentResponse::builder).logger(LOG, "changeRepositoryCompartment").serviceDetails("Artifacts", "ChangeRepositoryCompartment", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/ChangeRepositoryCompartment").method(Method.POST).requestBuilder(ChangeRepositoryCompartmentRequest::builder).basePath("/20160918").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRepositoryCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateContainerImageSignatureResponse> createContainerImageSignature(CreateContainerImageSignatureRequest request, AsyncHandler<CreateContainerImageSignatureRequest, CreateContainerImageSignatureResponse> handler) {
        Objects.requireNonNull(request.getCreateContainerImageSignatureDetails(), "createContainerImageSignatureDetails is required");
        return this.clientCall(request, CreateContainerImageSignatureResponse::builder).logger(LOG, "createContainerImageSignature").serviceDetails("Artifacts", "CreateContainerImageSignature", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImageSignature/CreateContainerImageSignature").method(Method.POST).requestBuilder(CreateContainerImageSignatureRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("imageSignatures").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ContainerImageSignature.class, CreateContainerImageSignatureResponse.Builder::containerImageSignature).handleResponseHeaderString("etag", CreateContainerImageSignatureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateContainerImageSignatureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateContainerRepositoryResponse> createContainerRepository(CreateContainerRepositoryRequest request, AsyncHandler<CreateContainerRepositoryRequest, CreateContainerRepositoryResponse> handler) {
        Objects.requireNonNull(request.getCreateContainerRepositoryDetails(), "createContainerRepositoryDetails is required");
        return this.clientCall(request, CreateContainerRepositoryResponse::builder).logger(LOG, "createContainerRepository").serviceDetails("Artifacts", "CreateContainerRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/CreateContainerRepository").method(Method.POST).requestBuilder(CreateContainerRepositoryRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ContainerRepository.class, CreateContainerRepositoryResponse.Builder::containerRepository).handleResponseHeaderString("etag", CreateContainerRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateContainerRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRepositoryResponse> createRepository(CreateRepositoryRequest request, AsyncHandler<CreateRepositoryRequest, CreateRepositoryResponse> handler) {
        Objects.requireNonNull(request.getCreateRepositoryDetails(), "createRepositoryDetails is required");
        return this.clientCall(request, CreateRepositoryResponse::builder).logger(LOG, "createRepository").serviceDetails("Artifacts", "CreateRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/CreateRepository").method(Method.POST).requestBuilder(CreateRepositoryRequest::builder).basePath("/20160918").appendPathParam("repositories").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Repository.class, CreateRepositoryResponse.Builder::repository).handleResponseHeaderString("etag", CreateRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteContainerImageResponse> deleteContainerImage(DeleteContainerImageRequest request, AsyncHandler<DeleteContainerImageRequest, DeleteContainerImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteContainerImageResponse::builder).logger(LOG, "deleteContainerImage").serviceDetails("Artifacts", "DeleteContainerImage", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImage/DeleteContainerImage").method(Method.DELETE).requestBuilder(DeleteContainerImageRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteContainerImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteContainerImageSignatureResponse> deleteContainerImageSignature(DeleteContainerImageSignatureRequest request, AsyncHandler<DeleteContainerImageSignatureRequest, DeleteContainerImageSignatureResponse> handler) {
        Validate.notBlank((String)request.getImageSignatureId(), (String)"imageSignatureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteContainerImageSignatureResponse::builder).logger(LOG, "deleteContainerImageSignature").serviceDetails("Artifacts", "DeleteContainerImageSignature", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImageSignature/DeleteContainerImageSignature").method(Method.DELETE).requestBuilder(DeleteContainerImageSignatureRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("imageSignatures").appendPathParam(request.getImageSignatureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteContainerImageSignatureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteContainerRepositoryResponse> deleteContainerRepository(DeleteContainerRepositoryRequest request, AsyncHandler<DeleteContainerRepositoryRequest, DeleteContainerRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteContainerRepositoryResponse::builder).logger(LOG, "deleteContainerRepository").serviceDetails("Artifacts", "DeleteContainerRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/DeleteContainerRepository").method(Method.DELETE).requestBuilder(DeleteContainerRepositoryRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteContainerRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteGenericArtifactResponse> deleteGenericArtifact(DeleteGenericArtifactRequest request, AsyncHandler<DeleteGenericArtifactRequest, DeleteGenericArtifactResponse> handler) {
        Validate.notBlank((String)request.getArtifactId(), (String)"artifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteGenericArtifactResponse::builder).logger(LOG, "deleteGenericArtifact").serviceDetails("Artifacts", "DeleteGenericArtifact", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/DeleteGenericArtifact").method(Method.DELETE).requestBuilder(DeleteGenericArtifactRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("artifacts").appendPathParam(request.getArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteGenericArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteGenericArtifactByPathResponse> deleteGenericArtifactByPath(DeleteGenericArtifactByPathRequest request, AsyncHandler<DeleteGenericArtifactByPathRequest, DeleteGenericArtifactByPathResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getArtifactPath(), (String)"artifactPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVersion(), (String)"version must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteGenericArtifactByPathResponse::builder).logger(LOG, "deleteGenericArtifactByPath").serviceDetails("Artifacts", "DeleteGenericArtifactByPath", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/DeleteGenericArtifactByPath").method(Method.DELETE).requestBuilder(DeleteGenericArtifactByPathRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("artifactPaths").appendPathParam(request.getArtifactPath()).appendPathParam("versions").appendPathParam(request.getVersion()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteGenericArtifactByPathResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest request, AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRepositoryResponse::builder).logger(LOG, "deleteRepository").serviceDetails("Artifacts", "DeleteRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/DeleteRepository").method(Method.DELETE).requestBuilder(DeleteRepositoryRequest::builder).basePath("/20160918").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerConfigurationResponse> getContainerConfiguration(GetContainerConfigurationRequest request, AsyncHandler<GetContainerConfigurationRequest, GetContainerConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetContainerConfigurationResponse::builder).logger(LOG, "getContainerConfiguration").serviceDetails("Artifacts", "GetContainerConfiguration", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerConfiguration/GetContainerConfiguration").method(Method.GET).requestBuilder(GetContainerConfigurationRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerConfiguration.class, GetContainerConfigurationResponse.Builder::containerConfiguration).handleResponseHeaderString("etag", GetContainerConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerImageResponse> getContainerImage(GetContainerImageRequest request, AsyncHandler<GetContainerImageRequest, GetContainerImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetContainerImageResponse::builder).logger(LOG, "getContainerImage").serviceDetails("Artifacts", "GetContainerImage", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImage/GetContainerImage").method(Method.GET).requestBuilder(GetContainerImageRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerImage.class, GetContainerImageResponse.Builder::containerImage).handleResponseHeaderString("etag", GetContainerImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerImageSignatureResponse> getContainerImageSignature(GetContainerImageSignatureRequest request, AsyncHandler<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse> handler) {
        Validate.notBlank((String)request.getImageSignatureId(), (String)"imageSignatureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetContainerImageSignatureResponse::builder).logger(LOG, "getContainerImageSignature").serviceDetails("Artifacts", "GetContainerImageSignature", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImageSignature/GetContainerImageSignature").method(Method.GET).requestBuilder(GetContainerImageSignatureRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("imageSignatures").appendPathParam(request.getImageSignatureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerImageSignature.class, GetContainerImageSignatureResponse.Builder::containerImageSignature).handleResponseHeaderString("etag", GetContainerImageSignatureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerImageSignatureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetContainerRepositoryResponse> getContainerRepository(GetContainerRepositoryRequest request, AsyncHandler<GetContainerRepositoryRequest, GetContainerRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetContainerRepositoryResponse::builder).logger(LOG, "getContainerRepository").serviceDetails("Artifacts", "GetContainerRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/GetContainerRepository").method(Method.GET).requestBuilder(GetContainerRepositoryRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerRepository.class, GetContainerRepositoryResponse.Builder::containerRepository).handleResponseHeaderString("etag", GetContainerRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetGenericArtifactResponse> getGenericArtifact(GetGenericArtifactRequest request, AsyncHandler<GetGenericArtifactRequest, GetGenericArtifactResponse> handler) {
        Validate.notBlank((String)request.getArtifactId(), (String)"artifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGenericArtifactResponse::builder).logger(LOG, "getGenericArtifact").serviceDetails("Artifacts", "GetGenericArtifact", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/GetGenericArtifact").method(Method.GET).requestBuilder(GetGenericArtifactRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("artifacts").appendPathParam(request.getArtifactId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GenericArtifact.class, GetGenericArtifactResponse.Builder::genericArtifact).handleResponseHeaderString("etag", GetGenericArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGenericArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetGenericArtifactByPathResponse> getGenericArtifactByPath(GetGenericArtifactByPathRequest request, AsyncHandler<GetGenericArtifactByPathRequest, GetGenericArtifactByPathResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getArtifactPath(), (String)"artifactPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVersion(), (String)"version must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGenericArtifactByPathResponse::builder).logger(LOG, "getGenericArtifactByPath").serviceDetails("Artifacts", "GetGenericArtifactByPath", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/GetGenericArtifactByPath").method(Method.GET).requestBuilder(GetGenericArtifactByPathRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("artifactPaths").appendPathParam(request.getArtifactPath()).appendPathParam("versions").appendPathParam(request.getVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GenericArtifact.class, GetGenericArtifactByPathResponse.Builder::genericArtifact).handleResponseHeaderString("etag", GetGenericArtifactByPathResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGenericArtifactByPathResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRepositoryResponse> getRepository(GetRepositoryRequest request, AsyncHandler<GetRepositoryRequest, GetRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRepositoryResponse::builder).logger(LOG, "getRepository").serviceDetails("Artifacts", "GetRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/GetRepository").method(Method.GET).requestBuilder(GetRepositoryRequest::builder).basePath("/20160918").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Repository.class, GetRepositoryResponse.Builder::repository).handleResponseHeaderString("etag", GetRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListContainerImageSignaturesResponse> listContainerImageSignatures(ListContainerImageSignaturesRequest request, AsyncHandler<ListContainerImageSignaturesRequest, ListContainerImageSignaturesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainerImageSignaturesResponse::builder).logger(LOG, "listContainerImageSignatures").serviceDetails("Artifacts", "ListContainerImageSignatures", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImageSignatureSummary/ListContainerImageSignatures").method(Method.GET).requestBuilder(ListContainerImageSignaturesRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("imageSignatures").appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("imageId", (Object)request.getImageId()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendQueryParam("repositoryName", (Object)request.getRepositoryName()).appendQueryParam("imageDigest", (Object)request.getImageDigest()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("kmsKeyId", (Object)request.getKmsKeyId()).appendQueryParam("kmsKeyVersionId", (Object)request.getKmsKeyVersionId()).appendEnumQueryParam("signingAlgorithm", (BmcEnum)request.getSigningAlgorithm()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerImageSignatureCollection.class, ListContainerImageSignaturesResponse.Builder::containerImageSignatureCollection).handleResponseHeaderString("opc-next-page", ListContainerImageSignaturesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListContainerImageSignaturesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListContainerImagesResponse> listContainerImages(ListContainerImagesRequest request, AsyncHandler<ListContainerImagesRequest, ListContainerImagesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainerImagesResponse::builder).logger(LOG, "listContainerImages").serviceDetails("Artifacts", "ListContainerImages", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImageSummary/ListContainerImages").method(Method.GET).requestBuilder(ListContainerImagesRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("images").appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("imageId", (Object)request.getImageId()).appendQueryParam("isVersioned", (Object)request.getIsVersioned()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendQueryParam("repositoryName", (Object)request.getRepositoryName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerImageCollection.class, ListContainerImagesResponse.Builder::containerImageCollection).handleResponseHeaderString("opc-next-page", ListContainerImagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListContainerImagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListContainerRepositoriesResponse> listContainerRepositories(ListContainerRepositoriesRequest request, AsyncHandler<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListContainerRepositoriesResponse::builder).logger(LOG, "listContainerRepositories").serviceDetails("Artifacts", "ListContainerRepositories", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/ListContainerRepositories").method(Method.GET).requestBuilder(ListContainerRepositoriesRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isPublic", (Object)request.getIsPublic()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerRepositoryCollection.class, ListContainerRepositoriesResponse.Builder::containerRepositoryCollection).handleResponseHeaderString("opc-next-page", ListContainerRepositoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListContainerRepositoriesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListGenericArtifactsResponse> listGenericArtifacts(ListGenericArtifactsRequest request, AsyncHandler<ListGenericArtifactsRequest, ListGenericArtifactsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getRepositoryId(), "repositoryId is required");
        return this.clientCall(request, ListGenericArtifactsResponse::builder).logger(LOG, "listGenericArtifacts").serviceDetails("Artifacts", "ListGenericArtifacts", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/ListGenericArtifacts").method(Method.GET).requestBuilder(ListGenericArtifactsRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("artifacts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("artifactPath", (Object)request.getArtifactPath()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("sha256", (Object)request.getSha256()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GenericArtifactCollection.class, ListGenericArtifactsResponse.Builder::genericArtifactCollection).handleResponseHeaderString("opc-next-page", ListGenericArtifactsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListGenericArtifactsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest request, AsyncHandler<ListRepositoriesRequest, ListRepositoriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRepositoriesResponse::builder).logger(LOG, "listRepositories").serviceDetails("Artifacts", "ListRepositories", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/ListRepositories").method(Method.GET).requestBuilder(ListRepositoriesRequest::builder).basePath("/20160918").appendPathParam("repositories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isImmutable", (Object)request.getIsImmutable()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RepositoryCollection.class, ListRepositoriesResponse.Builder::repositoryCollection).handleResponseHeaderString("opc-next-page", ListRepositoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRepositoriesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveContainerVersionResponse> removeContainerVersion(RemoveContainerVersionRequest request, AsyncHandler<RemoveContainerVersionRequest, RemoveContainerVersionResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveContainerVersionDetails(), "removeContainerVersionDetails is required");
        return this.clientCall(request, RemoveContainerVersionResponse::builder).logger(LOG, "removeContainerVersion").serviceDetails("Artifacts", "RemoveContainerVersion", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImage/RemoveContainerVersion").method(Method.POST).requestBuilder(RemoveContainerVersionRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("removeVersion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ContainerImage.class, RemoveContainerVersionResponse.Builder::containerImage).handleResponseHeaderString("etag", RemoveContainerVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveContainerVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreContainerImageResponse> restoreContainerImage(RestoreContainerImageRequest request, AsyncHandler<RestoreContainerImageRequest, RestoreContainerImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreContainerImageDetails(), "restoreContainerImageDetails is required");
        return this.clientCall(request, RestoreContainerImageResponse::builder).logger(LOG, "restoreContainerImage").serviceDetails("Artifacts", "RestoreContainerImage", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerImage/RestoreContainerImage").method(Method.POST).requestBuilder(RestoreContainerImageRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ContainerImage.class, RestoreContainerImageResponse.Builder::containerImage).handleResponseHeaderString("etag", RestoreContainerImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RestoreContainerImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateContainerConfigurationResponse> updateContainerConfiguration(UpdateContainerConfigurationRequest request, AsyncHandler<UpdateContainerConfigurationRequest, UpdateContainerConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateContainerConfigurationDetails(), "updateContainerConfigurationDetails is required");
        return this.clientCall(request, UpdateContainerConfigurationResponse::builder).logger(LOG, "updateContainerConfiguration").serviceDetails("Artifacts", "UpdateContainerConfiguration", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerConfiguration/UpdateContainerConfiguration").method(Method.PUT).requestBuilder(UpdateContainerConfigurationRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ContainerConfiguration.class, UpdateContainerConfigurationResponse.Builder::containerConfiguration).handleResponseHeaderString("etag", UpdateContainerConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateContainerConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateContainerRepositoryResponse> updateContainerRepository(UpdateContainerRepositoryRequest request, AsyncHandler<UpdateContainerRepositoryRequest, UpdateContainerRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerRepositoryDetails(), "updateContainerRepositoryDetails is required");
        return this.clientCall(request, UpdateContainerRepositoryResponse::builder).logger(LOG, "updateContainerRepository").serviceDetails("Artifacts", "UpdateContainerRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/ContainerRepository/UpdateContainerRepository").method(Method.PUT).requestBuilder(UpdateContainerRepositoryRequest::builder).basePath("/20160918").appendPathParam("container").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ContainerRepository.class, UpdateContainerRepositoryResponse.Builder::containerRepository).handleResponseHeaderString("etag", UpdateContainerRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateContainerRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateGenericArtifactResponse> updateGenericArtifact(UpdateGenericArtifactRequest request, AsyncHandler<UpdateGenericArtifactRequest, UpdateGenericArtifactResponse> handler) {
        Validate.notBlank((String)request.getArtifactId(), (String)"artifactId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGenericArtifactDetails(), "updateGenericArtifactDetails is required");
        return this.clientCall(request, UpdateGenericArtifactResponse::builder).logger(LOG, "updateGenericArtifact").serviceDetails("Artifacts", "UpdateGenericArtifact", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/UpdateGenericArtifact").method(Method.PUT).requestBuilder(UpdateGenericArtifactRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("artifacts").appendPathParam(request.getArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GenericArtifact.class, UpdateGenericArtifactResponse.Builder::genericArtifact).handleResponseHeaderString("etag", UpdateGenericArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateGenericArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateGenericArtifactByPathResponse> updateGenericArtifactByPath(UpdateGenericArtifactByPathRequest request, AsyncHandler<UpdateGenericArtifactByPathRequest, UpdateGenericArtifactByPathResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getArtifactPath(), (String)"artifactPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVersion(), (String)"version must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGenericArtifactByPathDetails(), "updateGenericArtifactByPathDetails is required");
        return this.clientCall(request, UpdateGenericArtifactByPathResponse::builder).logger(LOG, "updateGenericArtifactByPath").serviceDetails("Artifacts", "UpdateGenericArtifactByPath", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/GenericArtifact/UpdateGenericArtifactByPath").method(Method.PUT).requestBuilder(UpdateGenericArtifactByPathRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("artifactPaths").appendPathParam(request.getArtifactPath()).appendPathParam("versions").appendPathParam(request.getVersion()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GenericArtifact.class, UpdateGenericArtifactByPathResponse.Builder::genericArtifact).handleResponseHeaderString("etag", UpdateGenericArtifactByPathResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateGenericArtifactByPathResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRepositoryResponse> updateRepository(UpdateRepositoryRequest request, AsyncHandler<UpdateRepositoryRequest, UpdateRepositoryResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRepositoryDetails(), "updateRepositoryDetails is required");
        return this.clientCall(request, UpdateRepositoryResponse::builder).logger(LOG, "updateRepository").serviceDetails("Artifacts", "UpdateRepository", "https://docs.oracle.com/iaas/api/#/en/registry/20160918/Repository/UpdateRepository").method(Method.PUT).requestBuilder(UpdateRepositoryRequest::builder).basePath("/20160918").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Repository.class, UpdateRepositoryResponse.Builder::repository).handleResponseHeaderString("etag", UpdateRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRepositoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ArtifactsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ArtifactsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ArtifactsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ArtifactsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ArtifactsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ArtifactsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ArtifactsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ArtifactsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ArtifactsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ArtifactsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

