/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.appmgmtcontrol;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.appmgmtcontrol.AppmgmtControlAsync;
import com.oracle.bmc.appmgmtcontrol.model.MonitoredInstance;
import com.oracle.bmc.appmgmtcontrol.model.MonitoredInstanceCollection;
import com.oracle.bmc.appmgmtcontrol.model.WorkRequest;
import com.oracle.bmc.appmgmtcontrol.model.WorkRequestErrorCollection;
import com.oracle.bmc.appmgmtcontrol.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.appmgmtcontrol.model.WorkRequestSummaryCollection;
import com.oracle.bmc.appmgmtcontrol.requests.ActivateMonitoringPluginRequest;
import com.oracle.bmc.appmgmtcontrol.requests.GetMonitoredInstanceRequest;
import com.oracle.bmc.appmgmtcontrol.requests.GetWorkRequestRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListMonitoredInstancesRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.PublishTopProcessesMetricsRequest;
import com.oracle.bmc.appmgmtcontrol.responses.ActivateMonitoringPluginResponse;
import com.oracle.bmc.appmgmtcontrol.responses.GetMonitoredInstanceResponse;
import com.oracle.bmc.appmgmtcontrol.responses.GetWorkRequestResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListMonitoredInstancesResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.PublishTopProcessesMetricsResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppmgmtControlAsyncClient
extends BaseAsyncClient
implements AppmgmtControlAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPMGMTCONTROL").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp.appmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AppmgmtControlAsyncClient.class);

    private AppmgmtControlAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ActivateMonitoringPluginResponse> activateMonitoringPlugin(ActivateMonitoringPluginRequest request, AsyncHandler<ActivateMonitoringPluginRequest, ActivateMonitoringPluginResponse> handler) {
        Validate.notBlank((String)request.getMonitoredInstanceId(), (String)"monitoredInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ActivateMonitoringPluginResponse::builder).logger(LOG, "activateMonitoringPlugin").serviceDetails("AppmgmtControl", "ActivateMonitoringPlugin", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/MonitoredInstance/ActivateMonitoringPlugin").method(Method.POST).requestBuilder(ActivateMonitoringPluginRequest::builder).basePath("/20210330").appendPathParam("monitoredInstances").appendPathParam(request.getMonitoredInstanceId()).appendPathParam("actions").appendPathParam("activateMonitoringPlugin").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ActivateMonitoringPluginResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateMonitoringPluginResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMonitoredInstanceResponse> getMonitoredInstance(GetMonitoredInstanceRequest request, AsyncHandler<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse> handler) {
        Validate.notBlank((String)request.getMonitoredInstanceId(), (String)"monitoredInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMonitoredInstanceResponse::builder).logger(LOG, "getMonitoredInstance").serviceDetails("AppmgmtControl", "GetMonitoredInstance", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/MonitoredInstance/GetMonitoredInstance").method(Method.GET).requestBuilder(GetMonitoredInstanceRequest::builder).basePath("/20210330").appendPathParam("monitoredInstances").appendPathParam(request.getMonitoredInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MonitoredInstance.class, GetMonitoredInstanceResponse.Builder::monitoredInstance).handleResponseHeaderString("etag", GetMonitoredInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMonitoredInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AppmgmtControl", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListMonitoredInstancesResponse> listMonitoredInstances(ListMonitoredInstancesRequest request, AsyncHandler<ListMonitoredInstancesRequest, ListMonitoredInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListMonitoredInstancesResponse::builder).logger(LOG, "listMonitoredInstances").serviceDetails("AppmgmtControl", "ListMonitoredInstances", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/MonitoredInstanceCollection/ListMonitoredInstances").method(Method.GET).requestBuilder(ListMonitoredInstancesRequest::builder).basePath("/20210330").appendPathParam("monitoredInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MonitoredInstanceCollection.class, ListMonitoredInstancesResponse.Builder::monitoredInstanceCollection).handleResponseHeaderString("opc-request-id", ListMonitoredInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMonitoredInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AppmgmtControl", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AppmgmtControl", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AppmgmtControl", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PublishTopProcessesMetricsResponse> publishTopProcessesMetrics(PublishTopProcessesMetricsRequest request, AsyncHandler<PublishTopProcessesMetricsRequest, PublishTopProcessesMetricsResponse> handler) {
        Validate.notBlank((String)request.getMonitoredInstanceId(), (String)"monitoredInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, PublishTopProcessesMetricsResponse::builder).logger(LOG, "publishTopProcessesMetrics").serviceDetails("AppmgmtControl", "PublishTopProcessesMetrics", "https://docs.oracle.com/iaas/api/#/en/resource-discovery-monitoring-control-api/20210330/MonitoredInstance/PublishTopProcessesMetrics").method(Method.POST).requestBuilder(PublishTopProcessesMetricsRequest::builder).basePath("/20210330").appendPathParam("monitoredInstances").appendPathParam(request.getMonitoredInstanceId()).appendPathParam("actions").appendPathParam("publishTopProcessesMetrics").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", PublishTopProcessesMetricsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PublishTopProcessesMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AppmgmtControlAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AppmgmtControlAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AppmgmtControlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AppmgmtControlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AppmgmtControlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AppmgmtControlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AppmgmtControlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AppmgmtControlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AppmgmtControlAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AppmgmtControlAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AppmgmtControlAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

