/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.applicationmigration.model.UpdateMigrationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMigrationRequest
extends BmcRequest<UpdateMigrationDetails> {
    private String migrationId;
    private UpdateMigrationDetails updateMigrationDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getMigrationId() {
        return this.migrationId;
    }

    public UpdateMigrationDetails getUpdateMigrationDetails() {
        return this.updateMigrationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateMigrationDetails getBody$() {
        return this.updateMigrationDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationId(this.migrationId).updateMigrationDetails(this.updateMigrationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationId=").append(String.valueOf(this.migrationId));
        sb.append(",updateMigrationDetails=").append(String.valueOf((Object)this.updateMigrationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMigrationRequest)) {
            return false;
        }
        UpdateMigrationRequest other = (UpdateMigrationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationId, other.migrationId) && Objects.equals((Object)this.updateMigrationDetails, (Object)other.updateMigrationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationId == null ? 43 : this.migrationId.hashCode());
        result = result * 59 + (this.updateMigrationDetails == null ? 43 : this.updateMigrationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMigrationRequest, UpdateMigrationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationId = null;
        private UpdateMigrationDetails updateMigrationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder updateMigrationDetails(UpdateMigrationDetails updateMigrationDetails) {
            this.updateMigrationDetails = updateMigrationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMigrationRequest o) {
            this.migrationId(o.getMigrationId());
            this.updateMigrationDetails(o.getUpdateMigrationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMigrationRequest build() {
            UpdateMigrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMigrationDetails body) {
            this.updateMigrationDetails(body);
            return this;
        }

        public UpdateMigrationRequest buildWithoutInvocationCallback() {
            UpdateMigrationRequest request = new UpdateMigrationRequest();
            request.migrationId = this.migrationId;
            request.updateMigrationDetails = this.updateMigrationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

