/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.applicationmigration.model.ResourceField;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigurationField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="group")
    private final String group;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="resourceList")
    private final List<ResourceField> resourceList;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;
    @JsonProperty(value="isMutable")
    private final Boolean isMutable;

    @Deprecated
    @ConstructorProperties(value={"name", "group", "type", "value", "description", "resourceList", "isRequired", "isMutable"})
    public ConfigurationField(String name, String group, String type, String value, String description, List<ResourceField> resourceList, Boolean isRequired, Boolean isMutable) {
        this.name = name;
        this.group = group;
        this.type = type;
        this.value = value;
        this.description = description;
        this.resourceList = resourceList;
        this.isRequired = isRequired;
        this.isMutable = isMutable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ResourceField> getResourceList() {
        return this.resourceList;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public Boolean getIsMutable() {
        return this.isMutable;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigurationField(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", group=").append(String.valueOf(this.group));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", resourceList=").append(String.valueOf(this.resourceList));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(", isMutable=").append(String.valueOf(this.isMutable));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationField)) {
            return false;
        }
        ConfigurationField other = (ConfigurationField)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.group, other.group) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.description, other.description) && Objects.equals(this.resourceList, other.resourceList) && Objects.equals(this.isRequired, other.isRequired) && Objects.equals(this.isMutable, other.isMutable) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.group == null ? 43 : this.group.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.resourceList == null ? 43 : this.resourceList.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + (this.isMutable == null ? 43 : this.isMutable.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="group")
        private String group;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="resourceList")
        private List<ResourceField> resourceList;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonProperty(value="isMutable")
        private Boolean isMutable;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            this.__explicitlySet__.add("group");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder resourceList(List<ResourceField> resourceList) {
            this.resourceList = resourceList;
            this.__explicitlySet__.add("resourceList");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public Builder isMutable(Boolean isMutable) {
            this.isMutable = isMutable;
            this.__explicitlySet__.add("isMutable");
            return this;
        }

        public ConfigurationField build() {
            ConfigurationField model = new ConfigurationField(this.name, this.group, this.type, this.value, this.description, this.resourceList, this.isRequired, this.isMutable);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigurationField model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("group")) {
                this.group(model.getGroup());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("resourceList")) {
                this.resourceList(model.getResourceList());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            if (model.wasPropertyExplicitlySet("isMutable")) {
                this.isMutable(model.getIsMutable());
            }
            return this;
        }
    }
}

