/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTraceSnapshotRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String traceKey;
    private String opcRequestId;
    private Boolean isSummarized;
    private String threadId;
    private String snapshotTime;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsSummarized() {
        return this.isSummarized;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getSnapshotTime() {
        return this.snapshotTime;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).traceKey(this.traceKey).opcRequestId(this.opcRequestId).isSummarized(this.isSummarized).threadId(this.threadId).snapshotTime(this.snapshotTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",traceKey=").append(String.valueOf(this.traceKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isSummarized=").append(String.valueOf(this.isSummarized));
        sb.append(",threadId=").append(String.valueOf(this.threadId));
        sb.append(",snapshotTime=").append(String.valueOf(this.snapshotTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTraceSnapshotRequest)) {
            return false;
        }
        GetTraceSnapshotRequest other = (GetTraceSnapshotRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.traceKey, other.traceKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isSummarized, other.isSummarized) && Objects.equals(this.threadId, other.threadId) && Objects.equals(this.snapshotTime, other.snapshotTime);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.traceKey == null ? 43 : this.traceKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isSummarized == null ? 43 : this.isSummarized.hashCode());
        result = result * 59 + (this.threadId == null ? 43 : this.threadId.hashCode());
        result = result * 59 + (this.snapshotTime == null ? 43 : this.snapshotTime.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTraceSnapshotRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String traceKey = null;
        private String opcRequestId = null;
        private Boolean isSummarized = null;
        private String threadId = null;
        private String snapshotTime = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isSummarized(Boolean isSummarized) {
            this.isSummarized = isSummarized;
            return this;
        }

        public Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public Builder snapshotTime(String snapshotTime) {
            this.snapshotTime = snapshotTime;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTraceSnapshotRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.isSummarized(o.getIsSummarized());
            this.threadId(o.getThreadId());
            this.snapshotTime(o.getSnapshotTime());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTraceSnapshotRequest build() {
            GetTraceSnapshotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTraceSnapshotRequest buildWithoutInvocationCallback() {
            GetTraceSnapshotRequest request = new GetTraceSnapshotRequest();
            request.apmDomainId = this.apmDomainId;
            request.traceKey = this.traceKey;
            request.opcRequestId = this.opcRequestId;
            request.isSummarized = this.isSummarized;
            request.threadId = this.threadId;
            request.snapshotTime = this.snapshotTime;
            return request;
        }
    }
}

