/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmtraces.TraceAsyncClient;
import com.oracle.bmc.apmtraces.model.AggregatedSnapshot;
import com.oracle.bmc.apmtraces.model.Span;
import com.oracle.bmc.apmtraces.model.Trace;
import com.oracle.bmc.apmtraces.model.TraceSnapshot;
import com.oracle.bmc.apmtraces.requests.GetAggregatedSnapshotRequest;
import com.oracle.bmc.apmtraces.requests.GetSpanRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceSnapshotRequest;
import com.oracle.bmc.apmtraces.responses.GetAggregatedSnapshotResponse;
import com.oracle.bmc.apmtraces.responses.GetSpanResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceSnapshotResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceClient
extends BaseSyncClient
implements com.oracle.bmc.apmtraces.Trace {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRACE").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-trace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TraceAsyncClient.class);

    private TraceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetAggregatedSnapshotResponse getAggregatedSnapshot(GetAggregatedSnapshotRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return (GetAggregatedSnapshotResponse)this.clientCall(request, GetAggregatedSnapshotResponse::builder).logger(LOG, "getAggregatedSnapshot").serviceDetails("Trace", "GetAggregatedSnapshot", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/AggregatedSnapshot/GetAggregatedSnapshot").method(Method.GET).requestBuilder(GetAggregatedSnapshotRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendPathParam("aggregatedSnapshotData").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AggregatedSnapshot.class, GetAggregatedSnapshotResponse.Builder::aggregatedSnapshot).handleResponseHeaderString("opc-request-id", GetAggregatedSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSpanResponse getSpan(GetSpanRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getSpanKey(), (String)"spanKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return (GetSpanResponse)this.clientCall(request, GetSpanResponse::builder).logger(LOG, "getSpan").serviceDetails("Trace", "GetSpan", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/Span/GetSpan").method(Method.GET).requestBuilder(GetSpanRequest::builder).basePath("/20200630").appendPathParam("spans").appendPathParam(request.getTraceKey()).appendPathParam(request.getSpanKey()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Span.class, GetSpanResponse.Builder::span).handleResponseHeaderString("opc-request-id", GetSpanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTraceResponse getTrace(GetTraceRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return (GetTraceResponse)this.clientCall(request, GetTraceResponse::builder).logger(LOG, "getTrace").serviceDetails("Trace", "GetTrace", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/Trace/GetTrace").method(Method.GET).requestBuilder(GetTraceRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Trace.class, GetTraceResponse.Builder::trace).handleResponseHeaderString("opc-request-id", GetTraceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTraceSnapshotResponse getTraceSnapshot(GetTraceSnapshotRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return (GetTraceSnapshotResponse)this.clientCall(request, GetTraceSnapshotResponse::builder).logger(LOG, "getTraceSnapshot").serviceDetails("Trace", "GetTraceSnapshot", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/TraceSnapshot/GetTraceSnapshot").method(Method.GET).requestBuilder(GetTraceSnapshotRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendPathParam("snapshotData").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("isSummarized", (Object)request.getIsSummarized()).appendQueryParam("threadId", (Object)request.getThreadId()).appendQueryParam("snapshotTime", (Object)request.getSnapshotTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TraceSnapshot.class, GetTraceSnapshotResponse.Builder::traceSnapshot).handleResponseHeaderString("opc-request-id", GetTraceSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public TraceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TraceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TraceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TraceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TraceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TraceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TraceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TraceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TraceClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TraceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TraceClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

