/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.Header;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import com.oracle.bmc.apmsynthetics.model.RequestAuthenticationDetails;
import com.oracle.bmc.apmsynthetics.model.RequestAuthenticationSchemes;
import com.oracle.bmc.apmsynthetics.model.RequestMethods;
import com.oracle.bmc.apmsynthetics.model.RequestQueryParam;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class RestMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="isRedirectionEnabled")
    private final Boolean isRedirectionEnabled;
    @JsonProperty(value="isCertificateValidationEnabled")
    private final Boolean isCertificateValidationEnabled;
    @JsonProperty(value="requestMethod")
    private final RequestMethods requestMethod;
    @JsonProperty(value="reqAuthenticationScheme")
    private final RequestAuthenticationSchemes reqAuthenticationScheme;
    @JsonProperty(value="reqAuthenticationDetails")
    private final RequestAuthenticationDetails reqAuthenticationDetails;
    @JsonProperty(value="requestHeaders")
    private final List<Header> requestHeaders;
    @JsonProperty(value="requestQueryParams")
    private final List<RequestQueryParam> requestQueryParams;
    @JsonProperty(value="requestPostBody")
    private final String requestPostBody;
    @JsonProperty(value="verifyResponseContent")
    private final String verifyResponseContent;
    @JsonProperty(value="verifyResponseCodes")
    private final List<String> verifyResponseCodes;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RestMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, Boolean isRedirectionEnabled, Boolean isCertificateValidationEnabled, RequestMethods requestMethod, RequestAuthenticationSchemes reqAuthenticationScheme, RequestAuthenticationDetails reqAuthenticationDetails, List<Header> requestHeaders, List<RequestQueryParam> requestQueryParams, String requestPostBody, String verifyResponseContent, List<String> verifyResponseCodes, NetworkConfiguration networkConfiguration) {
        super(isFailureRetried, dnsConfiguration);
        this.isRedirectionEnabled = isRedirectionEnabled;
        this.isCertificateValidationEnabled = isCertificateValidationEnabled;
        this.requestMethod = requestMethod;
        this.reqAuthenticationScheme = reqAuthenticationScheme;
        this.reqAuthenticationDetails = reqAuthenticationDetails;
        this.requestHeaders = requestHeaders;
        this.requestQueryParams = requestQueryParams;
        this.requestPostBody = requestPostBody;
        this.verifyResponseContent = verifyResponseContent;
        this.verifyResponseCodes = verifyResponseCodes;
        this.networkConfiguration = networkConfiguration;
    }

    public Boolean getIsRedirectionEnabled() {
        return this.isRedirectionEnabled;
    }

    public Boolean getIsCertificateValidationEnabled() {
        return this.isCertificateValidationEnabled;
    }

    public RequestMethods getRequestMethod() {
        return this.requestMethod;
    }

    public RequestAuthenticationSchemes getReqAuthenticationScheme() {
        return this.reqAuthenticationScheme;
    }

    public RequestAuthenticationDetails getReqAuthenticationDetails() {
        return this.reqAuthenticationDetails;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public List<RequestQueryParam> getRequestQueryParams() {
        return this.requestQueryParams;
    }

    public String getRequestPostBody() {
        return this.requestPostBody;
    }

    public String getVerifyResponseContent() {
        return this.verifyResponseContent;
    }

    public List<String> getVerifyResponseCodes() {
        return this.verifyResponseCodes;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RestMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isRedirectionEnabled=").append(String.valueOf(this.isRedirectionEnabled));
        sb.append(", isCertificateValidationEnabled=").append(String.valueOf(this.isCertificateValidationEnabled));
        sb.append(", requestMethod=").append(String.valueOf((Object)this.requestMethod));
        sb.append(", reqAuthenticationScheme=").append(String.valueOf((Object)this.reqAuthenticationScheme));
        sb.append(", reqAuthenticationDetails=").append(String.valueOf((Object)this.reqAuthenticationDetails));
        sb.append(", requestHeaders=").append(String.valueOf(this.requestHeaders));
        sb.append(", requestQueryParams=").append(String.valueOf(this.requestQueryParams));
        sb.append(", requestPostBody=").append(String.valueOf(this.requestPostBody));
        sb.append(", verifyResponseContent=").append(String.valueOf(this.verifyResponseContent));
        sb.append(", verifyResponseCodes=").append(String.valueOf(this.verifyResponseCodes));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestMonitorConfiguration)) {
            return false;
        }
        RestMonitorConfiguration other = (RestMonitorConfiguration)((Object)o);
        return Objects.equals(this.isRedirectionEnabled, other.isRedirectionEnabled) && Objects.equals(this.isCertificateValidationEnabled, other.isCertificateValidationEnabled) && Objects.equals((Object)this.requestMethod, (Object)other.requestMethod) && Objects.equals((Object)this.reqAuthenticationScheme, (Object)other.reqAuthenticationScheme) && Objects.equals((Object)this.reqAuthenticationDetails, (Object)other.reqAuthenticationDetails) && Objects.equals(this.requestHeaders, other.requestHeaders) && Objects.equals(this.requestQueryParams, other.requestQueryParams) && Objects.equals(this.requestPostBody, other.requestPostBody) && Objects.equals(this.verifyResponseContent, other.verifyResponseContent) && Objects.equals(this.verifyResponseCodes, other.verifyResponseCodes) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRedirectionEnabled == null ? 43 : this.isRedirectionEnabled.hashCode());
        result = result * 59 + (this.isCertificateValidationEnabled == null ? 43 : this.isCertificateValidationEnabled.hashCode());
        result = result * 59 + (this.requestMethod == null ? 43 : this.requestMethod.hashCode());
        result = result * 59 + (this.reqAuthenticationScheme == null ? 43 : this.reqAuthenticationScheme.hashCode());
        result = result * 59 + (this.reqAuthenticationDetails == null ? 43 : this.reqAuthenticationDetails.hashCode());
        result = result * 59 + (this.requestHeaders == null ? 43 : this.requestHeaders.hashCode());
        result = result * 59 + (this.requestQueryParams == null ? 43 : this.requestQueryParams.hashCode());
        result = result * 59 + (this.requestPostBody == null ? 43 : this.requestPostBody.hashCode());
        result = result * 59 + (this.verifyResponseContent == null ? 43 : this.verifyResponseContent.hashCode());
        result = result * 59 + (this.verifyResponseCodes == null ? 43 : this.verifyResponseCodes.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="isRedirectionEnabled")
        private Boolean isRedirectionEnabled;
        @JsonProperty(value="isCertificateValidationEnabled")
        private Boolean isCertificateValidationEnabled;
        @JsonProperty(value="requestMethod")
        private RequestMethods requestMethod;
        @JsonProperty(value="reqAuthenticationScheme")
        private RequestAuthenticationSchemes reqAuthenticationScheme;
        @JsonProperty(value="reqAuthenticationDetails")
        private RequestAuthenticationDetails reqAuthenticationDetails;
        @JsonProperty(value="requestHeaders")
        private List<Header> requestHeaders;
        @JsonProperty(value="requestQueryParams")
        private List<RequestQueryParam> requestQueryParams;
        @JsonProperty(value="requestPostBody")
        private String requestPostBody;
        @JsonProperty(value="verifyResponseContent")
        private String verifyResponseContent;
        @JsonProperty(value="verifyResponseCodes")
        private List<String> verifyResponseCodes;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder isRedirectionEnabled(Boolean isRedirectionEnabled) {
            this.isRedirectionEnabled = isRedirectionEnabled;
            this.__explicitlySet__.add("isRedirectionEnabled");
            return this;
        }

        public Builder isCertificateValidationEnabled(Boolean isCertificateValidationEnabled) {
            this.isCertificateValidationEnabled = isCertificateValidationEnabled;
            this.__explicitlySet__.add("isCertificateValidationEnabled");
            return this;
        }

        public Builder requestMethod(RequestMethods requestMethod) {
            this.requestMethod = requestMethod;
            this.__explicitlySet__.add("requestMethod");
            return this;
        }

        public Builder reqAuthenticationScheme(RequestAuthenticationSchemes reqAuthenticationScheme) {
            this.reqAuthenticationScheme = reqAuthenticationScheme;
            this.__explicitlySet__.add("reqAuthenticationScheme");
            return this;
        }

        public Builder reqAuthenticationDetails(RequestAuthenticationDetails reqAuthenticationDetails) {
            this.reqAuthenticationDetails = reqAuthenticationDetails;
            this.__explicitlySet__.add("reqAuthenticationDetails");
            return this;
        }

        public Builder requestHeaders(List<Header> requestHeaders) {
            this.requestHeaders = requestHeaders;
            this.__explicitlySet__.add("requestHeaders");
            return this;
        }

        public Builder requestQueryParams(List<RequestQueryParam> requestQueryParams) {
            this.requestQueryParams = requestQueryParams;
            this.__explicitlySet__.add("requestQueryParams");
            return this;
        }

        public Builder requestPostBody(String requestPostBody) {
            this.requestPostBody = requestPostBody;
            this.__explicitlySet__.add("requestPostBody");
            return this;
        }

        public Builder verifyResponseContent(String verifyResponseContent) {
            this.verifyResponseContent = verifyResponseContent;
            this.__explicitlySet__.add("verifyResponseContent");
            return this;
        }

        public Builder verifyResponseCodes(List<String> verifyResponseCodes) {
            this.verifyResponseCodes = verifyResponseCodes;
            this.__explicitlySet__.add("verifyResponseCodes");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public RestMonitorConfiguration build() {
            RestMonitorConfiguration model = new RestMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.isRedirectionEnabled, this.isCertificateValidationEnabled, this.requestMethod, this.reqAuthenticationScheme, this.reqAuthenticationDetails, this.requestHeaders, this.requestQueryParams, this.requestPostBody, this.verifyResponseContent, this.verifyResponseCodes, this.networkConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RestMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("isRedirectionEnabled")) {
                this.isRedirectionEnabled(model.getIsRedirectionEnabled());
            }
            if (model.wasPropertyExplicitlySet("isCertificateValidationEnabled")) {
                this.isCertificateValidationEnabled(model.getIsCertificateValidationEnabled());
            }
            if (model.wasPropertyExplicitlySet("requestMethod")) {
                this.requestMethod(model.getRequestMethod());
            }
            if (model.wasPropertyExplicitlySet("reqAuthenticationScheme")) {
                this.reqAuthenticationScheme(model.getReqAuthenticationScheme());
            }
            if (model.wasPropertyExplicitlySet("reqAuthenticationDetails")) {
                this.reqAuthenticationDetails(model.getReqAuthenticationDetails());
            }
            if (model.wasPropertyExplicitlySet("requestHeaders")) {
                this.requestHeaders(model.getRequestHeaders());
            }
            if (model.wasPropertyExplicitlySet("requestQueryParams")) {
                this.requestQueryParams(model.getRequestQueryParams());
            }
            if (model.wasPropertyExplicitlySet("requestPostBody")) {
                this.requestPostBody(model.getRequestPostBody());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseContent")) {
                this.verifyResponseContent(model.getVerifyResponseContent());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseCodes")) {
                this.verifyResponseCodes(model.getVerifyResponseCodes());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            return this;
        }
    }
}

