/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListApmDomainWorkRequestsRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String opcRequestId;
    private String page;
    private Integer limit;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListApmDomainWorkRequestsRequest)) {
            return false;
        }
        ListApmDomainWorkRequestsRequest other = (ListApmDomainWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListApmDomainWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListApmDomainWorkRequestsRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListApmDomainWorkRequestsRequest build() {
            ListApmDomainWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListApmDomainWorkRequestsRequest buildWithoutInvocationCallback() {
            ListApmDomainWorkRequestsRequest request = new ListApmDomainWorkRequestsRequest();
            request.apmDomainId = this.apmDomainId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }
}

