/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmcontrolplane.ApmDomainAsyncClient;
import com.oracle.bmc.apmcontrolplane.ApmDomainPaginators;
import com.oracle.bmc.apmcontrolplane.ApmDomainWaiters;
import com.oracle.bmc.apmcontrolplane.model.ApmDomain;
import com.oracle.bmc.apmcontrolplane.model.ApmDomainSummary;
import com.oracle.bmc.apmcontrolplane.model.DataKeySummary;
import com.oracle.bmc.apmcontrolplane.model.WorkRequest;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestError;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestLogEntry;
import com.oracle.bmc.apmcontrolplane.requests.ChangeApmDomainCompartmentRequest;
import com.oracle.bmc.apmcontrolplane.requests.CreateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.DeleteApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GenerateDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.RemoveDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.UpdateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.responses.ChangeApmDomainCompartmentResponse;
import com.oracle.bmc.apmcontrolplane.responses.CreateApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.DeleteApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GenerateDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.RemoveDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.UpdateApmDomainResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmDomainClient
extends BaseSyncClient
implements com.oracle.bmc.apmcontrolplane.ApmDomain {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMDOMAIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-cp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApmDomainAsyncClient.class);
    private final ApmDomainWaiters waiters;
    private final ApmDomainPaginators paginators;

    private ApmDomainClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ApmDomain-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApmDomainWaiters(executorService, this);
        this.paginators = new ApmDomainPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeApmDomainCompartmentResponse changeApmDomainCompartment(ChangeApmDomainCompartmentRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApmDomainCompartmentDetails(), "changeApmDomainCompartmentDetails is required");
        return (ChangeApmDomainCompartmentResponse)this.clientCall(request, ChangeApmDomainCompartmentResponse::builder).logger(LOG, "changeApmDomainCompartment").serviceDetails("ApmDomain", "ChangeApmDomainCompartment", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/ChangeApmDomainCompartment").method(Method.POST).requestBuilder(ChangeApmDomainCompartmentRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeApmDomainCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeApmDomainCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateApmDomainResponse createApmDomain(CreateApmDomainRequest request) {
        Objects.requireNonNull(request.getCreateApmDomainDetails(), "createApmDomainDetails is required");
        return (CreateApmDomainResponse)this.clientCall(request, CreateApmDomainResponse::builder).logger(LOG, "createApmDomain").serviceDetails("ApmDomain", "CreateApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/CreateApmDomain").method(Method.POST).requestBuilder(CreateApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateApmDomainResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteApmDomainResponse deleteApmDomain(DeleteApmDomainRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return (DeleteApmDomainResponse)this.clientCall(request, DeleteApmDomainResponse::builder).logger(LOG, "deleteApmDomain").serviceDetails("ApmDomain", "DeleteApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/DeleteApmDomain").method(Method.DELETE).requestBuilder(DeleteApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteApmDomainResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GenerateDataKeysResponse generateDataKeys(GenerateDataKeysRequest request) {
        Objects.requireNonNull(request.getGenerateDataKeysListDetails(), "generateDataKeysListDetails is required");
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return (GenerateDataKeysResponse)this.clientCall(request, GenerateDataKeysResponse::builder).logger(LOG, "generateDataKeys").serviceDetails("ApmDomain", "GenerateDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKey/GenerateDataKeys").method(Method.POST).requestBuilder(GenerateDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("generateDataKeys").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", GenerateDataKeysResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateDataKeysResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetApmDomainResponse getApmDomain(GetApmDomainRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return (GetApmDomainResponse)this.clientCall(request, GetApmDomainResponse::builder).logger(LOG, "getApmDomain").serviceDetails("ApmDomain", "GetApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/GetApmDomain").method(Method.GET).requestBuilder(GetApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApmDomain.class, GetApmDomainResponse.Builder::apmDomain).handleResponseHeaderString("etag", GetApmDomainResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApmDomainResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ApmDomain", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListApmDomainWorkRequestsResponse listApmDomainWorkRequests(ListApmDomainWorkRequestsRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return (ListApmDomainWorkRequestsResponse)this.clientCall(request, ListApmDomainWorkRequestsResponse::builder).logger(LOG, "listApmDomainWorkRequests").serviceDetails("ApmDomain", "ListApmDomainWorkRequests", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/ListApmDomainWorkRequests").method(Method.GET).requestBuilder(ListApmDomainWorkRequestsRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("workRequests").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListApmDomainWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListApmDomainWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApmDomainWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListApmDomainsResponse listApmDomains(ListApmDomainsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListApmDomainsResponse)this.clientCall(request, ListApmDomainsResponse::builder).logger(LOG, "listApmDomains").serviceDetails("ApmDomain", "ListApmDomains", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomainSummary/ListApmDomains").method(Method.GET).requestBuilder(ListApmDomainsRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApmDomainSummary.class, ListApmDomainsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListApmDomainsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApmDomainsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListDataKeysResponse listDataKeys(ListDataKeysRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return (ListDataKeysResponse)this.clientCall(request, ListDataKeysResponse::builder).logger(LOG, "listDataKeys").serviceDetails("ApmDomain", "ListDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKeySummary/ListDataKeys").method(Method.GET).requestBuilder(ListDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("dataKeys").appendEnumQueryParam("dataKeyType", (BmcEnum)request.getDataKeyType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DataKeySummary.class, ListDataKeysResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDataKeysResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ApmDomain", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ApmDomain", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ApmDomain", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveDataKeysResponse removeDataKeys(RemoveDataKeysRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDataKeysListDetails(), "removeDataKeysListDetails is required");
        return (RemoveDataKeysResponse)this.clientCall(request, RemoveDataKeysResponse::builder).logger(LOG, "removeDataKeys").serviceDetails("ApmDomain", "RemoveDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKey/RemoveDataKeys").method(Method.POST).requestBuilder(RemoveDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("removeDataKeys").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveDataKeysResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveDataKeysResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateApmDomainResponse updateApmDomain(UpdateApmDomainRequest request) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApmDomainDetails(), "updateApmDomainDetails is required");
        return (UpdateApmDomainResponse)this.clientCall(request, UpdateApmDomainResponse::builder).logger(LOG, "updateApmDomain").serviceDetails("ApmDomain", "UpdateApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/UpdateApmDomain").method(Method.PUT).requestBuilder(UpdateApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateApmDomainResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ApmDomainWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApmDomainPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApmDomainClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApmDomainClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApmDomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmDomainClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApmDomainClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApmDomainClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

