/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAnnouncementsPreferenceRequest
extends BmcRequest<Void> {
    private String preferenceId;
    private String opcRequestId;

    public String getPreferenceId() {
        return this.preferenceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().preferenceId(this.preferenceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",preferenceId=").append(String.valueOf(this.preferenceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAnnouncementsPreferenceRequest)) {
            return false;
        }
        GetAnnouncementsPreferenceRequest other = (GetAnnouncementsPreferenceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.preferenceId, other.preferenceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.preferenceId == null ? 43 : this.preferenceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAnnouncementsPreferenceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String preferenceId = null;
        private String opcRequestId = null;

        public Builder preferenceId(String preferenceId) {
            this.preferenceId = preferenceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAnnouncementsPreferenceRequest o) {
            this.preferenceId(o.getPreferenceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAnnouncementsPreferenceRequest build() {
            GetAnnouncementsPreferenceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAnnouncementsPreferenceRequest buildWithoutInvocationCallback() {
            GetAnnouncementsPreferenceRequest request = new GetAnnouncementsPreferenceRequest();
            request.preferenceId = this.preferenceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

