/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.announcementsservice.AnnouncementSubscription;
import com.oracle.bmc.announcementsservice.model.AnnouncementSubscriptionSummary;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementSubscriptionsRequest;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementSubscriptionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AnnouncementSubscriptionPaginators {
    private final AnnouncementSubscription client;

    public AnnouncementSubscriptionPaginators(AnnouncementSubscription client) {
        this.client = client;
    }

    public Iterable<ListAnnouncementSubscriptionsResponse> listAnnouncementSubscriptionsResponseIterator(final ListAnnouncementSubscriptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnnouncementSubscriptionsRequest.Builder>(){

            @Override
            public ListAnnouncementSubscriptionsRequest.Builder get() {
                return ListAnnouncementSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementSubscriptionsResponse, String>(){

            @Override
            public String apply(ListAnnouncementSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementSubscriptionsRequest.Builder>, ListAnnouncementSubscriptionsRequest>(){

            @Override
            public ListAnnouncementSubscriptionsRequest apply(RequestBuilderAndToken<ListAnnouncementSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnouncementSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnouncementSubscriptionsRequest, ListAnnouncementSubscriptionsResponse>(){

            @Override
            public ListAnnouncementSubscriptionsResponse apply(ListAnnouncementSubscriptionsRequest request) {
                return AnnouncementSubscriptionPaginators.this.client.listAnnouncementSubscriptions(request);
            }
        });
    }

    public Iterable<AnnouncementSubscriptionSummary> listAnnouncementSubscriptionsRecordIterator(final ListAnnouncementSubscriptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnnouncementSubscriptionsRequest.Builder>(){

            @Override
            public ListAnnouncementSubscriptionsRequest.Builder get() {
                return ListAnnouncementSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementSubscriptionsResponse, String>(){

            @Override
            public String apply(ListAnnouncementSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementSubscriptionsRequest.Builder>, ListAnnouncementSubscriptionsRequest>(){

            @Override
            public ListAnnouncementSubscriptionsRequest apply(RequestBuilderAndToken<ListAnnouncementSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnouncementSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnouncementSubscriptionsRequest, ListAnnouncementSubscriptionsResponse>(){

            @Override
            public ListAnnouncementSubscriptionsResponse apply(ListAnnouncementSubscriptionsRequest request) {
                return AnnouncementSubscriptionPaginators.this.client.listAnnouncementSubscriptions(request);
            }
        }, (Function)new Function<ListAnnouncementSubscriptionsResponse, List<AnnouncementSubscriptionSummary>>(){

            @Override
            public List<AnnouncementSubscriptionSummary> apply(ListAnnouncementSubscriptionsResponse response) {
                return response.getAnnouncementSubscriptionCollection().getItems();
            }
        });
    }
}

