/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPrivateAccessChannelRequest
extends BmcRequest<Void> {
    private String privateAccessChannelKey;
    private String analyticsInstanceId;
    private String opcRequestId;

    public String getPrivateAccessChannelKey() {
        return this.privateAccessChannelKey;
    }

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().privateAccessChannelKey(this.privateAccessChannelKey).analyticsInstanceId(this.analyticsInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateAccessChannelKey=").append(String.valueOf(this.privateAccessChannelKey));
        sb.append(",analyticsInstanceId=").append(String.valueOf(this.analyticsInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPrivateAccessChannelRequest)) {
            return false;
        }
        GetPrivateAccessChannelRequest other = (GetPrivateAccessChannelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateAccessChannelKey, other.privateAccessChannelKey) && Objects.equals(this.analyticsInstanceId, other.analyticsInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateAccessChannelKey == null ? 43 : this.privateAccessChannelKey.hashCode());
        result = result * 59 + (this.analyticsInstanceId == null ? 43 : this.analyticsInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPrivateAccessChannelRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateAccessChannelKey = null;
        private String analyticsInstanceId = null;
        private String opcRequestId = null;

        public Builder privateAccessChannelKey(String privateAccessChannelKey) {
            this.privateAccessChannelKey = privateAccessChannelKey;
            return this;
        }

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateAccessChannelRequest o) {
            this.privateAccessChannelKey(o.getPrivateAccessChannelKey());
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateAccessChannelRequest build() {
            GetPrivateAccessChannelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPrivateAccessChannelRequest buildWithoutInvocationCallback() {
            GetPrivateAccessChannelRequest request = new GetPrivateAccessChannelRequest();
            request.privateAccessChannelKey = this.privateAccessChannelKey;
            request.analyticsInstanceId = this.analyticsInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

