/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.analytics.model.CreateVanityUrlDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateVanityUrlRequest
extends BmcRequest<CreateVanityUrlDetails> {
    private String analyticsInstanceId;
    private CreateVanityUrlDetails createVanityUrlDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public CreateVanityUrlDetails getCreateVanityUrlDetails() {
        return this.createVanityUrlDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateVanityUrlDetails getBody$() {
        return this.createVanityUrlDetails;
    }

    public Builder toBuilder() {
        return new Builder().analyticsInstanceId(this.analyticsInstanceId).createVanityUrlDetails(this.createVanityUrlDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",analyticsInstanceId=").append(String.valueOf(this.analyticsInstanceId));
        sb.append(",createVanityUrlDetails=").append(String.valueOf((Object)this.createVanityUrlDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVanityUrlRequest)) {
            return false;
        }
        CreateVanityUrlRequest other = (CreateVanityUrlRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.analyticsInstanceId, other.analyticsInstanceId) && Objects.equals((Object)this.createVanityUrlDetails, (Object)other.createVanityUrlDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.analyticsInstanceId == null ? 43 : this.analyticsInstanceId.hashCode());
        result = result * 59 + (this.createVanityUrlDetails == null ? 43 : this.createVanityUrlDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateVanityUrlRequest, CreateVanityUrlDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String analyticsInstanceId = null;
        private CreateVanityUrlDetails createVanityUrlDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder createVanityUrlDetails(CreateVanityUrlDetails createVanityUrlDetails) {
            this.createVanityUrlDetails = createVanityUrlDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateVanityUrlRequest o) {
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.createVanityUrlDetails(o.getCreateVanityUrlDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateVanityUrlRequest build() {
            CreateVanityUrlRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateVanityUrlDetails body) {
            this.createVanityUrlDetails(body);
            return this;
        }

        public CreateVanityUrlRequest buildWithoutInvocationCallback() {
            CreateVanityUrlRequest request = new CreateVanityUrlRequest();
            request.analyticsInstanceId = this.analyticsInstanceId;
            request.createVanityUrlDetails = this.createVanityUrlDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

