/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.analytics.model.WorkRequestActionResult;
import com.oracle.bmc.analytics.model.WorkRequestResourceType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="actionResult")
    private final WorkRequestActionResult actionResult;
    @JsonProperty(value="resourceType")
    private final WorkRequestResourceType resourceType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="resourceUri")
    private final String resourceUri;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;

    @Deprecated
    @ConstructorProperties(value={"actionResult", "resourceType", "identifier", "resourceUri", "metadata"})
    public WorkRequestResource(WorkRequestActionResult actionResult, WorkRequestResourceType resourceType, String identifier, String resourceUri, Map<String, String> metadata) {
        this.actionResult = actionResult;
        this.resourceType = resourceType;
        this.identifier = identifier;
        this.resourceUri = resourceUri;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public WorkRequestActionResult getActionResult() {
        return this.actionResult;
    }

    public WorkRequestResourceType getResourceType() {
        return this.resourceType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("super=").append(super.toString());
        sb.append("actionResult=").append(String.valueOf((Object)this.actionResult));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", resourceUri=").append(String.valueOf(this.resourceUri));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)((Object)o);
        return Objects.equals((Object)this.actionResult, (Object)other.actionResult) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.resourceUri, other.resourceUri) && Objects.equals(this.metadata, other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.actionResult == null ? 43 : this.actionResult.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.resourceUri == null ? 43 : this.resourceUri.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="actionResult")
        private WorkRequestActionResult actionResult;
        @JsonProperty(value="resourceType")
        private WorkRequestResourceType resourceType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="resourceUri")
        private String resourceUri;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder actionResult(WorkRequestActionResult actionResult) {
            this.actionResult = actionResult;
            this.__explicitlySet__.add("actionResult");
            return this;
        }

        public Builder resourceType(WorkRequestResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            this.__explicitlySet__.add("resourceUri");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource model = new WorkRequestResource(this.actionResult, this.resourceType, this.identifier, this.resourceUri, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource model) {
            if (model.wasPropertyExplicitlySet("actionResult")) {
                this.actionResult(model.getActionResult());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("resourceUri")) {
                this.resourceUri(model.getResourceUri());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

