/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.analytics.model.Capacity;
import com.oracle.bmc.analytics.model.FeatureSet;
import com.oracle.bmc.analytics.model.LicenseType;
import com.oracle.bmc.analytics.model.NetworkEndpointDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateAnalyticsInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="featureSet")
    private final FeatureSet featureSet;
    @JsonProperty(value="capacity")
    private final Capacity capacity;
    @JsonProperty(value="licenseType")
    private final LicenseType licenseType;
    @JsonProperty(value="emailNotification")
    private final String emailNotification;
    @JsonProperty(value="networkEndpointDetails")
    private final NetworkEndpointDetails networkEndpointDetails;
    @JsonProperty(value="idcsAccessToken")
    private final String idcsAccessToken;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "compartmentId", "featureSet", "capacity", "licenseType", "emailNotification", "networkEndpointDetails", "idcsAccessToken", "definedTags", "freeformTags", "kmsKeyId"})
    public CreateAnalyticsInstanceDetails(String name, String description, String compartmentId, FeatureSet featureSet, Capacity capacity, LicenseType licenseType, String emailNotification, NetworkEndpointDetails networkEndpointDetails, String idcsAccessToken, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, String kmsKeyId) {
        this.name = name;
        this.description = description;
        this.compartmentId = compartmentId;
        this.featureSet = featureSet;
        this.capacity = capacity;
        this.licenseType = licenseType;
        this.emailNotification = emailNotification;
        this.networkEndpointDetails = networkEndpointDetails;
        this.idcsAccessToken = idcsAccessToken;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.kmsKeyId = kmsKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getEmailNotification() {
        return this.emailNotification;
    }

    public NetworkEndpointDetails getNetworkEndpointDetails() {
        return this.networkEndpointDetails;
    }

    public String getIdcsAccessToken() {
        return this.idcsAccessToken;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAnalyticsInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", featureSet=").append(String.valueOf((Object)this.featureSet));
        sb.append(", capacity=").append(String.valueOf((Object)this.capacity));
        sb.append(", licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(", emailNotification=").append(String.valueOf(this.emailNotification));
        sb.append(", networkEndpointDetails=").append(String.valueOf((Object)this.networkEndpointDetails));
        sb.append(", idcsAccessToken=").append(String.valueOf(this.idcsAccessToken));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAnalyticsInstanceDetails)) {
            return false;
        }
        CreateAnalyticsInstanceDetails other = (CreateAnalyticsInstanceDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.featureSet, (Object)other.featureSet) && Objects.equals((Object)this.capacity, (Object)other.capacity) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals(this.emailNotification, other.emailNotification) && Objects.equals((Object)this.networkEndpointDetails, (Object)other.networkEndpointDetails) && Objects.equals(this.idcsAccessToken, other.idcsAccessToken) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.featureSet == null ? 43 : this.featureSet.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.emailNotification == null ? 43 : this.emailNotification.hashCode());
        result = result * 59 + (this.networkEndpointDetails == null ? 43 : this.networkEndpointDetails.hashCode());
        result = result * 59 + (this.idcsAccessToken == null ? 43 : this.idcsAccessToken.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="featureSet")
        private FeatureSet featureSet;
        @JsonProperty(value="capacity")
        private Capacity capacity;
        @JsonProperty(value="licenseType")
        private LicenseType licenseType;
        @JsonProperty(value="emailNotification")
        private String emailNotification;
        @JsonProperty(value="networkEndpointDetails")
        private NetworkEndpointDetails networkEndpointDetails;
        @JsonProperty(value="idcsAccessToken")
        private String idcsAccessToken;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder featureSet(FeatureSet featureSet) {
            this.featureSet = featureSet;
            this.__explicitlySet__.add("featureSet");
            return this;
        }

        public Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            this.__explicitlySet__.add("licenseType");
            return this;
        }

        public Builder emailNotification(String emailNotification) {
            this.emailNotification = emailNotification;
            this.__explicitlySet__.add("emailNotification");
            return this;
        }

        public Builder networkEndpointDetails(NetworkEndpointDetails networkEndpointDetails) {
            this.networkEndpointDetails = networkEndpointDetails;
            this.__explicitlySet__.add("networkEndpointDetails");
            return this;
        }

        public Builder idcsAccessToken(String idcsAccessToken) {
            this.idcsAccessToken = idcsAccessToken;
            this.__explicitlySet__.add("idcsAccessToken");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public CreateAnalyticsInstanceDetails build() {
            CreateAnalyticsInstanceDetails model = new CreateAnalyticsInstanceDetails(this.name, this.description, this.compartmentId, this.featureSet, this.capacity, this.licenseType, this.emailNotification, this.networkEndpointDetails, this.idcsAccessToken, this.definedTags, this.freeformTags, this.kmsKeyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAnalyticsInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("featureSet")) {
                this.featureSet(model.getFeatureSet());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("licenseType")) {
                this.licenseType(model.getLicenseType());
            }
            if (model.wasPropertyExplicitlySet("emailNotification")) {
                this.emailNotification(model.getEmailNotification());
            }
            if (model.wasPropertyExplicitlySet("networkEndpointDetails")) {
                this.networkEndpointDetails(model.getNetworkEndpointDetails());
            }
            if (model.wasPropertyExplicitlySet("idcsAccessToken")) {
                this.idcsAccessToken(model.getIdcsAccessToken());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            return this;
        }
    }
}

