/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.DetectedDocumentType;
import com.oracle.bmc.aivision.model.DetectedLanguage;
import com.oracle.bmc.aivision.model.Dimensions;
import com.oracle.bmc.aivision.model.DocumentField;
import com.oracle.bmc.aivision.model.Line;
import com.oracle.bmc.aivision.model.Table;
import com.oracle.bmc.aivision.model.Word;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Page
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pageNumber")
    private final Integer pageNumber;
    @JsonProperty(value="dimensions")
    private final Dimensions dimensions;
    @JsonProperty(value="detectedDocumentTypes")
    private final List<DetectedDocumentType> detectedDocumentTypes;
    @JsonProperty(value="detectedLanguages")
    private final List<DetectedLanguage> detectedLanguages;
    @JsonProperty(value="words")
    private final List<Word> words;
    @JsonProperty(value="lines")
    private final List<Line> lines;
    @JsonProperty(value="tables")
    private final List<Table> tables;
    @JsonProperty(value="documentFields")
    private final List<DocumentField> documentFields;

    @Deprecated
    @ConstructorProperties(value={"pageNumber", "dimensions", "detectedDocumentTypes", "detectedLanguages", "words", "lines", "tables", "documentFields"})
    public Page(Integer pageNumber, Dimensions dimensions, List<DetectedDocumentType> detectedDocumentTypes, List<DetectedLanguage> detectedLanguages, List<Word> words, List<Line> lines, List<Table> tables, List<DocumentField> documentFields) {
        this.pageNumber = pageNumber;
        this.dimensions = dimensions;
        this.detectedDocumentTypes = detectedDocumentTypes;
        this.detectedLanguages = detectedLanguages;
        this.words = words;
        this.lines = lines;
        this.tables = tables;
        this.documentFields = documentFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public List<DetectedDocumentType> getDetectedDocumentTypes() {
        return this.detectedDocumentTypes;
    }

    public List<DetectedLanguage> getDetectedLanguages() {
        return this.detectedLanguages;
    }

    public List<Word> getWords() {
        return this.words;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<DocumentField> getDocumentFields() {
        return this.documentFields;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Page(");
        sb.append("super=").append(super.toString());
        sb.append("pageNumber=").append(String.valueOf(this.pageNumber));
        sb.append(", dimensions=").append(String.valueOf((Object)this.dimensions));
        sb.append(", detectedDocumentTypes=").append(String.valueOf(this.detectedDocumentTypes));
        sb.append(", detectedLanguages=").append(String.valueOf(this.detectedLanguages));
        sb.append(", words=").append(String.valueOf(this.words));
        sb.append(", lines=").append(String.valueOf(this.lines));
        sb.append(", tables=").append(String.valueOf(this.tables));
        sb.append(", documentFields=").append(String.valueOf(this.documentFields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)((Object)o);
        return Objects.equals(this.pageNumber, other.pageNumber) && Objects.equals((Object)this.dimensions, (Object)other.dimensions) && Objects.equals(this.detectedDocumentTypes, other.detectedDocumentTypes) && Objects.equals(this.detectedLanguages, other.detectedLanguages) && Objects.equals(this.words, other.words) && Objects.equals(this.lines, other.lines) && Objects.equals(this.tables, other.tables) && Objects.equals(this.documentFields, other.documentFields) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pageNumber == null ? 43 : this.pageNumber.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.detectedDocumentTypes == null ? 43 : this.detectedDocumentTypes.hashCode());
        result = result * 59 + (this.detectedLanguages == null ? 43 : this.detectedLanguages.hashCode());
        result = result * 59 + (this.words == null ? 43 : this.words.hashCode());
        result = result * 59 + (this.lines == null ? 43 : this.lines.hashCode());
        result = result * 59 + (this.tables == null ? 43 : this.tables.hashCode());
        result = result * 59 + (this.documentFields == null ? 43 : this.documentFields.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="dimensions")
        private Dimensions dimensions;
        @JsonProperty(value="detectedDocumentTypes")
        private List<DetectedDocumentType> detectedDocumentTypes;
        @JsonProperty(value="detectedLanguages")
        private List<DetectedLanguage> detectedLanguages;
        @JsonProperty(value="words")
        private List<Word> words;
        @JsonProperty(value="lines")
        private List<Line> lines;
        @JsonProperty(value="tables")
        private List<Table> tables;
        @JsonProperty(value="documentFields")
        private List<DocumentField> documentFields;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            this.__explicitlySet__.add("pageNumber");
            return this;
        }

        public Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder detectedDocumentTypes(List<DetectedDocumentType> detectedDocumentTypes) {
            this.detectedDocumentTypes = detectedDocumentTypes;
            this.__explicitlySet__.add("detectedDocumentTypes");
            return this;
        }

        public Builder detectedLanguages(List<DetectedLanguage> detectedLanguages) {
            this.detectedLanguages = detectedLanguages;
            this.__explicitlySet__.add("detectedLanguages");
            return this;
        }

        public Builder words(List<Word> words) {
            this.words = words;
            this.__explicitlySet__.add("words");
            return this;
        }

        public Builder lines(List<Line> lines) {
            this.lines = lines;
            this.__explicitlySet__.add("lines");
            return this;
        }

        public Builder tables(List<Table> tables) {
            this.tables = tables;
            this.__explicitlySet__.add("tables");
            return this;
        }

        public Builder documentFields(List<DocumentField> documentFields) {
            this.documentFields = documentFields;
            this.__explicitlySet__.add("documentFields");
            return this;
        }

        public Page build() {
            Page model = new Page(this.pageNumber, this.dimensions, this.detectedDocumentTypes, this.detectedLanguages, this.words, this.lines, this.tables, this.documentFields);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Page model) {
            if (model.wasPropertyExplicitlySet("pageNumber")) {
                this.pageNumber(model.getPageNumber());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("detectedDocumentTypes")) {
                this.detectedDocumentTypes(model.getDetectedDocumentTypes());
            }
            if (model.wasPropertyExplicitlySet("detectedLanguages")) {
                this.detectedLanguages(model.getDetectedLanguages());
            }
            if (model.wasPropertyExplicitlySet("words")) {
                this.words(model.getWords());
            }
            if (model.wasPropertyExplicitlySet("lines")) {
                this.lines(model.getLines());
            }
            if (model.wasPropertyExplicitlySet("tables")) {
                this.tables(model.getTables());
            }
            if (model.wasPropertyExplicitlySet("documentFields")) {
                this.documentFields(model.getDocumentFields());
            }
            return this;
        }
    }
}

