/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Dimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="width")
    private final Double width;
    @JsonProperty(value="height")
    private final Double height;
    @JsonProperty(value="unit")
    private final Unit unit;

    @Deprecated
    @ConstructorProperties(value={"width", "height", "unit"})
    public Dimensions(Double width, Double height, Unit unit) {
        this.width = width;
        this.height = height;
        this.unit = unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dimensions(");
        sb.append("super=").append(super.toString());
        sb.append("width=").append(String.valueOf(this.width));
        sb.append(", height=").append(String.valueOf(this.height));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)((Object)o);
        return Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height) && Objects.equals((Object)this.unit, (Object)other.unit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.width == null ? 43 : this.width.hashCode());
        result = result * 59 + (this.height == null ? 43 : this.height.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Unit implements BmcEnum
    {
        Pixel("PIXEL"),
        Inch("INCH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Unit> map;

        private Unit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Unit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Unit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Unit.class);
            map = new HashMap<String, Unit>();
            for (Unit v : Unit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="width")
        private Double width;
        @JsonProperty(value="height")
        private Double height;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder width(Double width) {
            this.width = width;
            this.__explicitlySet__.add("width");
            return this;
        }

        public Builder height(Double height) {
            this.height = height;
            this.__explicitlySet__.add("height");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Dimensions build() {
            Dimensions model = new Dimensions(this.width, this.height, this.unit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Dimensions model) {
            if (model.wasPropertyExplicitlySet("width")) {
                this.width(model.getWidth());
            }
            if (model.wasPropertyExplicitlySet("height")) {
                this.height(model.getHeight());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            return this;
        }
    }
}

