/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.ImageObject;
import com.oracle.bmc.aivision.model.ImageText;
import com.oracle.bmc.aivision.model.Label;
import com.oracle.bmc.aivision.model.OntologyClass;
import com.oracle.bmc.aivision.model.ProcessingError;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnalyzeImageResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="imageObjects")
    private final List<ImageObject> imageObjects;
    @JsonProperty(value="labels")
    private final List<Label> labels;
    @JsonProperty(value="ontologyClasses")
    private final List<OntologyClass> ontologyClasses;
    @JsonProperty(value="imageText")
    private final ImageText imageText;
    @JsonProperty(value="imageClassificationModelVersion")
    private final String imageClassificationModelVersion;
    @JsonProperty(value="objectDetectionModelVersion")
    private final String objectDetectionModelVersion;
    @JsonProperty(value="textDetectionModelVersion")
    private final String textDetectionModelVersion;
    @JsonProperty(value="errors")
    private final List<ProcessingError> errors;

    @Deprecated
    @ConstructorProperties(value={"imageObjects", "labels", "ontologyClasses", "imageText", "imageClassificationModelVersion", "objectDetectionModelVersion", "textDetectionModelVersion", "errors"})
    public AnalyzeImageResult(List<ImageObject> imageObjects, List<Label> labels, List<OntologyClass> ontologyClasses, ImageText imageText, String imageClassificationModelVersion, String objectDetectionModelVersion, String textDetectionModelVersion, List<ProcessingError> errors) {
        this.imageObjects = imageObjects;
        this.labels = labels;
        this.ontologyClasses = ontologyClasses;
        this.imageText = imageText;
        this.imageClassificationModelVersion = imageClassificationModelVersion;
        this.objectDetectionModelVersion = objectDetectionModelVersion;
        this.textDetectionModelVersion = textDetectionModelVersion;
        this.errors = errors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ImageObject> getImageObjects() {
        return this.imageObjects;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public List<OntologyClass> getOntologyClasses() {
        return this.ontologyClasses;
    }

    public ImageText getImageText() {
        return this.imageText;
    }

    public String getImageClassificationModelVersion() {
        return this.imageClassificationModelVersion;
    }

    public String getObjectDetectionModelVersion() {
        return this.objectDetectionModelVersion;
    }

    public String getTextDetectionModelVersion() {
        return this.textDetectionModelVersion;
    }

    public List<ProcessingError> getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalyzeImageResult(");
        sb.append("super=").append(super.toString());
        sb.append("imageObjects=").append(String.valueOf(this.imageObjects));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(", ontologyClasses=").append(String.valueOf(this.ontologyClasses));
        sb.append(", imageText=").append(String.valueOf((Object)this.imageText));
        sb.append(", imageClassificationModelVersion=").append(String.valueOf(this.imageClassificationModelVersion));
        sb.append(", objectDetectionModelVersion=").append(String.valueOf(this.objectDetectionModelVersion));
        sb.append(", textDetectionModelVersion=").append(String.valueOf(this.textDetectionModelVersion));
        sb.append(", errors=").append(String.valueOf(this.errors));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzeImageResult)) {
            return false;
        }
        AnalyzeImageResult other = (AnalyzeImageResult)((Object)o);
        return Objects.equals(this.imageObjects, other.imageObjects) && Objects.equals(this.labels, other.labels) && Objects.equals(this.ontologyClasses, other.ontologyClasses) && Objects.equals((Object)this.imageText, (Object)other.imageText) && Objects.equals(this.imageClassificationModelVersion, other.imageClassificationModelVersion) && Objects.equals(this.objectDetectionModelVersion, other.objectDetectionModelVersion) && Objects.equals(this.textDetectionModelVersion, other.textDetectionModelVersion) && Objects.equals(this.errors, other.errors) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.imageObjects == null ? 43 : this.imageObjects.hashCode());
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        result = result * 59 + (this.ontologyClasses == null ? 43 : this.ontologyClasses.hashCode());
        result = result * 59 + (this.imageText == null ? 43 : this.imageText.hashCode());
        result = result * 59 + (this.imageClassificationModelVersion == null ? 43 : this.imageClassificationModelVersion.hashCode());
        result = result * 59 + (this.objectDetectionModelVersion == null ? 43 : this.objectDetectionModelVersion.hashCode());
        result = result * 59 + (this.textDetectionModelVersion == null ? 43 : this.textDetectionModelVersion.hashCode());
        result = result * 59 + (this.errors == null ? 43 : this.errors.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="imageObjects")
        private List<ImageObject> imageObjects;
        @JsonProperty(value="labels")
        private List<Label> labels;
        @JsonProperty(value="ontologyClasses")
        private List<OntologyClass> ontologyClasses;
        @JsonProperty(value="imageText")
        private ImageText imageText;
        @JsonProperty(value="imageClassificationModelVersion")
        private String imageClassificationModelVersion;
        @JsonProperty(value="objectDetectionModelVersion")
        private String objectDetectionModelVersion;
        @JsonProperty(value="textDetectionModelVersion")
        private String textDetectionModelVersion;
        @JsonProperty(value="errors")
        private List<ProcessingError> errors;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder imageObjects(List<ImageObject> imageObjects) {
            this.imageObjects = imageObjects;
            this.__explicitlySet__.add("imageObjects");
            return this;
        }

        public Builder labels(List<Label> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public Builder ontologyClasses(List<OntologyClass> ontologyClasses) {
            this.ontologyClasses = ontologyClasses;
            this.__explicitlySet__.add("ontologyClasses");
            return this;
        }

        public Builder imageText(ImageText imageText) {
            this.imageText = imageText;
            this.__explicitlySet__.add("imageText");
            return this;
        }

        public Builder imageClassificationModelVersion(String imageClassificationModelVersion) {
            this.imageClassificationModelVersion = imageClassificationModelVersion;
            this.__explicitlySet__.add("imageClassificationModelVersion");
            return this;
        }

        public Builder objectDetectionModelVersion(String objectDetectionModelVersion) {
            this.objectDetectionModelVersion = objectDetectionModelVersion;
            this.__explicitlySet__.add("objectDetectionModelVersion");
            return this;
        }

        public Builder textDetectionModelVersion(String textDetectionModelVersion) {
            this.textDetectionModelVersion = textDetectionModelVersion;
            this.__explicitlySet__.add("textDetectionModelVersion");
            return this;
        }

        public Builder errors(List<ProcessingError> errors) {
            this.errors = errors;
            this.__explicitlySet__.add("errors");
            return this;
        }

        public AnalyzeImageResult build() {
            AnalyzeImageResult model = new AnalyzeImageResult(this.imageObjects, this.labels, this.ontologyClasses, this.imageText, this.imageClassificationModelVersion, this.objectDetectionModelVersion, this.textDetectionModelVersion, this.errors);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnalyzeImageResult model) {
            if (model.wasPropertyExplicitlySet("imageObjects")) {
                this.imageObjects(model.getImageObjects());
            }
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            if (model.wasPropertyExplicitlySet("ontologyClasses")) {
                this.ontologyClasses(model.getOntologyClasses());
            }
            if (model.wasPropertyExplicitlySet("imageText")) {
                this.imageText(model.getImageText());
            }
            if (model.wasPropertyExplicitlySet("imageClassificationModelVersion")) {
                this.imageClassificationModelVersion(model.getImageClassificationModelVersion());
            }
            if (model.wasPropertyExplicitlySet("objectDetectionModelVersion")) {
                this.objectDetectionModelVersion(model.getObjectDetectionModelVersion());
            }
            if (model.wasPropertyExplicitlySet("textDetectionModelVersion")) {
                this.textDetectionModelVersion(model.getTextDetectionModelVersion());
            }
            if (model.wasPropertyExplicitlySet("errors")) {
                this.errors(model.getErrors());
            }
            return this;
        }
    }
}

