/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aivision.AIServiceVision;
import com.oracle.bmc.aivision.AIServiceVisionAsyncClient;
import com.oracle.bmc.aivision.AIServiceVisionPaginators;
import com.oracle.bmc.aivision.AIServiceVisionWaiters;
import com.oracle.bmc.aivision.model.AnalyzeDocumentResult;
import com.oracle.bmc.aivision.model.AnalyzeImageResult;
import com.oracle.bmc.aivision.model.DocumentJob;
import com.oracle.bmc.aivision.model.ImageJob;
import com.oracle.bmc.aivision.model.Model;
import com.oracle.bmc.aivision.model.ModelCollection;
import com.oracle.bmc.aivision.model.Project;
import com.oracle.bmc.aivision.model.ProjectCollection;
import com.oracle.bmc.aivision.model.WorkRequest;
import com.oracle.bmc.aivision.model.WorkRequestErrorCollection;
import com.oracle.bmc.aivision.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.aivision.model.WorkRequestSummaryCollection;
import com.oracle.bmc.aivision.requests.AnalyzeDocumentRequest;
import com.oracle.bmc.aivision.requests.AnalyzeImageRequest;
import com.oracle.bmc.aivision.requests.CancelDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CancelImageJobRequest;
import com.oracle.bmc.aivision.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aivision.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aivision.requests.CreateDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CreateImageJobRequest;
import com.oracle.bmc.aivision.requests.CreateModelRequest;
import com.oracle.bmc.aivision.requests.CreateProjectRequest;
import com.oracle.bmc.aivision.requests.DeleteModelRequest;
import com.oracle.bmc.aivision.requests.DeleteProjectRequest;
import com.oracle.bmc.aivision.requests.GetDocumentJobRequest;
import com.oracle.bmc.aivision.requests.GetImageJobRequest;
import com.oracle.bmc.aivision.requests.GetModelRequest;
import com.oracle.bmc.aivision.requests.GetProjectRequest;
import com.oracle.bmc.aivision.requests.GetWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ListModelsRequest;
import com.oracle.bmc.aivision.requests.ListProjectsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aivision.requests.UpdateModelRequest;
import com.oracle.bmc.aivision.requests.UpdateProjectRequest;
import com.oracle.bmc.aivision.responses.AnalyzeDocumentResponse;
import com.oracle.bmc.aivision.responses.AnalyzeImageResponse;
import com.oracle.bmc.aivision.responses.CancelDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CancelImageJobResponse;
import com.oracle.bmc.aivision.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aivision.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aivision.responses.CreateDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CreateImageJobResponse;
import com.oracle.bmc.aivision.responses.CreateModelResponse;
import com.oracle.bmc.aivision.responses.CreateProjectResponse;
import com.oracle.bmc.aivision.responses.DeleteModelResponse;
import com.oracle.bmc.aivision.responses.DeleteProjectResponse;
import com.oracle.bmc.aivision.responses.GetDocumentJobResponse;
import com.oracle.bmc.aivision.responses.GetImageJobResponse;
import com.oracle.bmc.aivision.responses.GetModelResponse;
import com.oracle.bmc.aivision.responses.GetProjectResponse;
import com.oracle.bmc.aivision.responses.GetWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ListModelsResponse;
import com.oracle.bmc.aivision.responses.ListProjectsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aivision.responses.UpdateModelResponse;
import com.oracle.bmc.aivision.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceVisionClient
extends BaseSyncClient
implements AIServiceVision {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEVISION").serviceEndpointPrefix("").serviceEndpointTemplate("https://vision.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceVisionAsyncClient.class);
    private final AIServiceVisionWaiters waiters;
    private final AIServiceVisionPaginators paginators;

    private AIServiceVisionClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AIServiceVision-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AIServiceVisionWaiters(executorService, this);
        this.paginators = new AIServiceVisionPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AnalyzeDocumentResponse analyzeDocument(AnalyzeDocumentRequest request) {
        Objects.requireNonNull(request.getAnalyzeDocumentDetails(), "analyzeDocumentDetails is required");
        return (AnalyzeDocumentResponse)this.clientCall(request, AnalyzeDocumentResponse::builder).logger(LOG, "analyzeDocument").serviceDetails("AIServiceVision", "AnalyzeDocument", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/AnalyzeDocumentResult/AnalyzeDocument").method(Method.POST).requestBuilder(AnalyzeDocumentRequest::builder).basePath("/20220125").appendPathParam("actions").appendPathParam("analyzeDocument").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeDocumentResult.class, AnalyzeDocumentResponse.Builder::analyzeDocumentResult).handleResponseHeaderString("etag", AnalyzeDocumentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeDocumentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AnalyzeImageResponse analyzeImage(AnalyzeImageRequest request) {
        Objects.requireNonNull(request.getAnalyzeImageDetails(), "analyzeImageDetails is required");
        return (AnalyzeImageResponse)this.clientCall(request, AnalyzeImageResponse::builder).logger(LOG, "analyzeImage").serviceDetails("AIServiceVision", "AnalyzeImage", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/AnalyzeImageResult/AnalyzeImage").method(Method.POST).requestBuilder(AnalyzeImageRequest::builder).basePath("/20220125").appendPathParam("actions").appendPathParam("analyzeImage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeImageResult.class, AnalyzeImageResponse.Builder::analyzeImageResult).handleResponseHeaderString("etag", AnalyzeImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeImageResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CancelDocumentJobResponse cancelDocumentJob(CancelDocumentJobRequest request) {
        Validate.notBlank((String)request.getDocumentJobId(), (String)"documentJobId must not be blank", (Object[])new Object[0]);
        return (CancelDocumentJobResponse)this.clientCall(request, CancelDocumentJobResponse::builder).logger(LOG, "cancelDocumentJob").serviceDetails("AIServiceVision", "CancelDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/CancelDocumentJob").method(Method.POST).requestBuilder(CancelDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").appendPathParam(request.getDocumentJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelDocumentJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelImageJobResponse cancelImageJob(CancelImageJobRequest request) {
        Validate.notBlank((String)request.getImageJobId(), (String)"imageJobId must not be blank", (Object[])new Object[0]);
        return (CancelImageJobResponse)this.clientCall(request, CancelImageJobResponse::builder).logger(LOG, "cancelImageJob").serviceDetails("AIServiceVision", "CancelImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/CancelImageJob").method(Method.POST).requestBuilder(CancelImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").appendPathParam(request.getImageJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelImageJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("AIServiceVision", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return (ChangeModelCompartmentResponse)this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AIServiceVision", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return (ChangeProjectCompartmentResponse)this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AIServiceVision", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDocumentJobResponse createDocumentJob(CreateDocumentJobRequest request) {
        Objects.requireNonNull(request.getCreateDocumentJobDetails(), "createDocumentJobDetails is required");
        return (CreateDocumentJobResponse)this.clientCall(request, CreateDocumentJobResponse::builder).logger(LOG, "createDocumentJob").serviceDetails("AIServiceVision", "CreateDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/CreateDocumentJob").method(Method.POST).requestBuilder(CreateDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DocumentJob.class, CreateDocumentJobResponse.Builder::documentJob).handleResponseHeaderString("etag", CreateDocumentJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDocumentJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateImageJobResponse createImageJob(CreateImageJobRequest request) {
        Objects.requireNonNull(request.getCreateImageJobDetails(), "createImageJobDetails is required");
        return (CreateImageJobResponse)this.clientCall(request, CreateImageJobResponse::builder).logger(LOG, "createImageJob").serviceDetails("AIServiceVision", "CreateImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/CreateImageJob").method(Method.POST).requestBuilder(CreateImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ImageJob.class, CreateImageJobResponse.Builder::imageJob).handleResponseHeaderString("etag", CreateImageJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateImageJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return (CreateModelResponse)this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AIServiceVision", "CreateModel", "").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20220125").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).callSync();
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return (CreateProjectResponse)this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AIServiceVision", "CreateProject", "").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20220125").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (DeleteModelResponse)this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AIServiceVision", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectResponse)this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AIServiceVision", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDocumentJobResponse getDocumentJob(GetDocumentJobRequest request) {
        Validate.notBlank((String)request.getDocumentJobId(), (String)"documentJobId must not be blank", (Object[])new Object[0]);
        return (GetDocumentJobResponse)this.clientCall(request, GetDocumentJobResponse::builder).logger(LOG, "getDocumentJob").serviceDetails("AIServiceVision", "GetDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/GetDocumentJob").method(Method.GET).requestBuilder(GetDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").appendPathParam(request.getDocumentJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DocumentJob.class, GetDocumentJobResponse.Builder::documentJob).handleResponseHeaderString("etag", GetDocumentJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDocumentJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetImageJobResponse getImageJob(GetImageJobRequest request) {
        Validate.notBlank((String)request.getImageJobId(), (String)"imageJobId must not be blank", (Object[])new Object[0]);
        return (GetImageJobResponse)this.clientCall(request, GetImageJobResponse::builder).logger(LOG, "getImageJob").serviceDetails("AIServiceVision", "GetImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/GetImageJob").method(Method.GET).requestBuilder(GetImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").appendPathParam(request.getImageJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ImageJob.class, GetImageJobResponse.Builder::imageJob).handleResponseHeaderString("etag", GetImageJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetImageJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelResponse)this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AIServiceVision", "GetModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectResponse)this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AIServiceVision", "GetProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AIServiceVision", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        return (ListModelsResponse)this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AIServiceVision", "ListModels", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ModelCollection/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20220125").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        return (ListProjectsResponse)this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AIServiceVision", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ProjectCollection/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20220125").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AIServiceVision", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AIServiceVision", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AIServiceVision", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return (UpdateModelResponse)this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AIServiceVision", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return (UpdateProjectResponse)this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AIServiceVision", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AIServiceVisionWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AIServiceVisionPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AIServiceVisionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceVisionClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceVisionClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceVisionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceVisionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceVisionClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AIServiceVisionClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceVisionClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

