/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech;

import com.oracle.bmc.aispeech.AIServiceSpeech;
import com.oracle.bmc.aispeech.model.TranscriptionJobSummary;
import com.oracle.bmc.aispeech.model.TranscriptionTaskSummary;
import com.oracle.bmc.aispeech.requests.ListTranscriptionJobsRequest;
import com.oracle.bmc.aispeech.requests.ListTranscriptionTasksRequest;
import com.oracle.bmc.aispeech.responses.ListTranscriptionJobsResponse;
import com.oracle.bmc.aispeech.responses.ListTranscriptionTasksResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AIServiceSpeechPaginators {
    private final AIServiceSpeech client;

    public AIServiceSpeechPaginators(AIServiceSpeech client) {
        this.client = client;
    }

    public Iterable<ListTranscriptionJobsResponse> listTranscriptionJobsResponseIterator(final ListTranscriptionJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTranscriptionJobsRequest.Builder>(){

            @Override
            public ListTranscriptionJobsRequest.Builder get() {
                return ListTranscriptionJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTranscriptionJobsResponse, String>(){

            @Override
            public String apply(ListTranscriptionJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTranscriptionJobsRequest.Builder>, ListTranscriptionJobsRequest>(){

            @Override
            public ListTranscriptionJobsRequest apply(RequestBuilderAndToken<ListTranscriptionJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTranscriptionJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTranscriptionJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTranscriptionJobsRequest, ListTranscriptionJobsResponse>(){

            @Override
            public ListTranscriptionJobsResponse apply(ListTranscriptionJobsRequest request) {
                return AIServiceSpeechPaginators.this.client.listTranscriptionJobs(request);
            }
        });
    }

    public Iterable<TranscriptionJobSummary> listTranscriptionJobsRecordIterator(final ListTranscriptionJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTranscriptionJobsRequest.Builder>(){

            @Override
            public ListTranscriptionJobsRequest.Builder get() {
                return ListTranscriptionJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTranscriptionJobsResponse, String>(){

            @Override
            public String apply(ListTranscriptionJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTranscriptionJobsRequest.Builder>, ListTranscriptionJobsRequest>(){

            @Override
            public ListTranscriptionJobsRequest apply(RequestBuilderAndToken<ListTranscriptionJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTranscriptionJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTranscriptionJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTranscriptionJobsRequest, ListTranscriptionJobsResponse>(){

            @Override
            public ListTranscriptionJobsResponse apply(ListTranscriptionJobsRequest request) {
                return AIServiceSpeechPaginators.this.client.listTranscriptionJobs(request);
            }
        }, (Function)new Function<ListTranscriptionJobsResponse, List<TranscriptionJobSummary>>(){

            @Override
            public List<TranscriptionJobSummary> apply(ListTranscriptionJobsResponse response) {
                return response.getTranscriptionJobCollection().getItems();
            }
        });
    }

    public Iterable<ListTranscriptionTasksResponse> listTranscriptionTasksResponseIterator(final ListTranscriptionTasksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTranscriptionTasksRequest.Builder>(){

            @Override
            public ListTranscriptionTasksRequest.Builder get() {
                return ListTranscriptionTasksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTranscriptionTasksResponse, String>(){

            @Override
            public String apply(ListTranscriptionTasksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTranscriptionTasksRequest.Builder>, ListTranscriptionTasksRequest>(){

            @Override
            public ListTranscriptionTasksRequest apply(RequestBuilderAndToken<ListTranscriptionTasksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTranscriptionTasksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTranscriptionTasksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTranscriptionTasksRequest, ListTranscriptionTasksResponse>(){

            @Override
            public ListTranscriptionTasksResponse apply(ListTranscriptionTasksRequest request) {
                return AIServiceSpeechPaginators.this.client.listTranscriptionTasks(request);
            }
        });
    }

    public Iterable<TranscriptionTaskSummary> listTranscriptionTasksRecordIterator(final ListTranscriptionTasksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTranscriptionTasksRequest.Builder>(){

            @Override
            public ListTranscriptionTasksRequest.Builder get() {
                return ListTranscriptionTasksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTranscriptionTasksResponse, String>(){

            @Override
            public String apply(ListTranscriptionTasksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTranscriptionTasksRequest.Builder>, ListTranscriptionTasksRequest>(){

            @Override
            public ListTranscriptionTasksRequest apply(RequestBuilderAndToken<ListTranscriptionTasksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTranscriptionTasksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTranscriptionTasksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTranscriptionTasksRequest, ListTranscriptionTasksResponse>(){

            @Override
            public ListTranscriptionTasksResponse apply(ListTranscriptionTasksRequest request) {
                return AIServiceSpeechPaginators.this.client.listTranscriptionTasks(request);
            }
        }, (Function)new Function<ListTranscriptionTasksResponse, List<TranscriptionTaskSummary>>(){

            @Override
            public List<TranscriptionTaskSummary> apply(ListTranscriptionTasksResponse response) {
                return response.getTranscriptionTaskCollection().getItems();
            }
        });
    }
}

