/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.BoundingPolygon;
import com.oracle.bmc.aidocument.model.TableRow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Table
extends ExplicitlySetBmcModel {
    @JsonProperty(value="rowCount")
    private final Integer rowCount;
    @JsonProperty(value="columnCount")
    private final Integer columnCount;
    @JsonProperty(value="headerRows")
    private final List<TableRow> headerRows;
    @JsonProperty(value="bodyRows")
    private final List<TableRow> bodyRows;
    @JsonProperty(value="footerRows")
    private final List<TableRow> footerRows;
    @JsonProperty(value="confidence")
    private final Float confidence;
    @JsonProperty(value="boundingPolygon")
    private final BoundingPolygon boundingPolygon;

    @Deprecated
    @ConstructorProperties(value={"rowCount", "columnCount", "headerRows", "bodyRows", "footerRows", "confidence", "boundingPolygon"})
    public Table(Integer rowCount, Integer columnCount, List<TableRow> headerRows, List<TableRow> bodyRows, List<TableRow> footerRows, Float confidence, BoundingPolygon boundingPolygon) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.headerRows = headerRows;
        this.bodyRows = bodyRows;
        this.footerRows = footerRows;
        this.confidence = confidence;
        this.boundingPolygon = boundingPolygon;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public List<TableRow> getHeaderRows() {
        return this.headerRows;
    }

    public List<TableRow> getBodyRows() {
        return this.bodyRows;
    }

    public List<TableRow> getFooterRows() {
        return this.footerRows;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public BoundingPolygon getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Table(");
        sb.append("super=").append(super.toString());
        sb.append("rowCount=").append(String.valueOf(this.rowCount));
        sb.append(", columnCount=").append(String.valueOf(this.columnCount));
        sb.append(", headerRows=").append(String.valueOf(this.headerRows));
        sb.append(", bodyRows=").append(String.valueOf(this.bodyRows));
        sb.append(", footerRows=").append(String.valueOf(this.footerRows));
        sb.append(", confidence=").append(String.valueOf(this.confidence));
        sb.append(", boundingPolygon=").append(String.valueOf((Object)this.boundingPolygon));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)((Object)o);
        return Objects.equals(this.rowCount, other.rowCount) && Objects.equals(this.columnCount, other.columnCount) && Objects.equals(this.headerRows, other.headerRows) && Objects.equals(this.bodyRows, other.bodyRows) && Objects.equals(this.footerRows, other.footerRows) && Objects.equals(this.confidence, other.confidence) && Objects.equals((Object)this.boundingPolygon, (Object)other.boundingPolygon) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.rowCount == null ? 43 : this.rowCount.hashCode());
        result = result * 59 + (this.columnCount == null ? 43 : this.columnCount.hashCode());
        result = result * 59 + (this.headerRows == null ? 43 : this.headerRows.hashCode());
        result = result * 59 + (this.bodyRows == null ? 43 : this.bodyRows.hashCode());
        result = result * 59 + (this.footerRows == null ? 43 : this.footerRows.hashCode());
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.boundingPolygon == null ? 43 : this.boundingPolygon.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rowCount")
        private Integer rowCount;
        @JsonProperty(value="columnCount")
        private Integer columnCount;
        @JsonProperty(value="headerRows")
        private List<TableRow> headerRows;
        @JsonProperty(value="bodyRows")
        private List<TableRow> bodyRows;
        @JsonProperty(value="footerRows")
        private List<TableRow> footerRows;
        @JsonProperty(value="confidence")
        private Float confidence;
        @JsonProperty(value="boundingPolygon")
        private BoundingPolygon boundingPolygon;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rowCount(Integer rowCount) {
            this.rowCount = rowCount;
            this.__explicitlySet__.add("rowCount");
            return this;
        }

        public Builder columnCount(Integer columnCount) {
            this.columnCount = columnCount;
            this.__explicitlySet__.add("columnCount");
            return this;
        }

        public Builder headerRows(List<TableRow> headerRows) {
            this.headerRows = headerRows;
            this.__explicitlySet__.add("headerRows");
            return this;
        }

        public Builder bodyRows(List<TableRow> bodyRows) {
            this.bodyRows = bodyRows;
            this.__explicitlySet__.add("bodyRows");
            return this;
        }

        public Builder footerRows(List<TableRow> footerRows) {
            this.footerRows = footerRows;
            this.__explicitlySet__.add("footerRows");
            return this;
        }

        public Builder confidence(Float confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder boundingPolygon(BoundingPolygon boundingPolygon) {
            this.boundingPolygon = boundingPolygon;
            this.__explicitlySet__.add("boundingPolygon");
            return this;
        }

        public Table build() {
            Table model = new Table(this.rowCount, this.columnCount, this.headerRows, this.bodyRows, this.footerRows, this.confidence, this.boundingPolygon);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Table model) {
            if (model.wasPropertyExplicitlySet("rowCount")) {
                this.rowCount(model.getRowCount());
            }
            if (model.wasPropertyExplicitlySet("columnCount")) {
                this.columnCount(model.getColumnCount());
            }
            if (model.wasPropertyExplicitlySet("headerRows")) {
                this.headerRows(model.getHeaderRows());
            }
            if (model.wasPropertyExplicitlySet("bodyRows")) {
                this.bodyRows(model.getBodyRows());
            }
            if (model.wasPropertyExplicitlySet("footerRows")) {
                this.footerRows(model.getFooterRows());
            }
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("boundingPolygon")) {
                this.boundingPolygon(model.getBoundingPolygon());
            }
            return this;
        }
    }
}

