/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.FieldLabel;
import com.oracle.bmc.aidocument.model.FieldName;
import com.oracle.bmc.aidocument.model.FieldValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DocumentField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldType")
    private final FieldType fieldType;
    @JsonProperty(value="fieldLabel")
    private final FieldLabel fieldLabel;
    @JsonProperty(value="fieldName")
    private final FieldName fieldName;
    @JsonProperty(value="fieldValue")
    private final FieldValue fieldValue;

    @Deprecated
    @ConstructorProperties(value={"fieldType", "fieldLabel", "fieldName", "fieldValue"})
    public DocumentField(FieldType fieldType, FieldLabel fieldLabel, FieldName fieldName, FieldValue fieldValue) {
        this.fieldType = fieldType;
        this.fieldLabel = fieldLabel;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public FieldLabel getFieldLabel() {
        return this.fieldLabel;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DocumentField(");
        sb.append("super=").append(super.toString());
        sb.append("fieldType=").append(String.valueOf((Object)this.fieldType));
        sb.append(", fieldLabel=").append(String.valueOf((Object)this.fieldLabel));
        sb.append(", fieldName=").append(String.valueOf((Object)this.fieldName));
        sb.append(", fieldValue=").append(String.valueOf((Object)this.fieldValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentField)) {
            return false;
        }
        DocumentField other = (DocumentField)((Object)o);
        return Objects.equals((Object)this.fieldType, (Object)other.fieldType) && Objects.equals((Object)this.fieldLabel, (Object)other.fieldLabel) && Objects.equals((Object)this.fieldName, (Object)other.fieldName) && Objects.equals((Object)this.fieldValue, (Object)other.fieldValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldType == null ? 43 : this.fieldType.hashCode());
        result = result * 59 + (this.fieldLabel == null ? 43 : this.fieldLabel.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.fieldValue == null ? 43 : this.fieldValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FieldType implements BmcEnum
    {
        LineItemGroup("LINE_ITEM_GROUP"),
        LineItem("LINE_ITEM"),
        LineItemField("LINE_ITEM_FIELD"),
        KeyValue("KEY_VALUE");

        private final String value;
        private static Map<String, FieldType> map;

        private FieldType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FieldType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FieldType: " + key);
        }

        static {
            map = new HashMap<String, FieldType>();
            for (FieldType v : FieldType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldType")
        private FieldType fieldType;
        @JsonProperty(value="fieldLabel")
        private FieldLabel fieldLabel;
        @JsonProperty(value="fieldName")
        private FieldName fieldName;
        @JsonProperty(value="fieldValue")
        private FieldValue fieldValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            this.__explicitlySet__.add("fieldType");
            return this;
        }

        public Builder fieldLabel(FieldLabel fieldLabel) {
            this.fieldLabel = fieldLabel;
            this.__explicitlySet__.add("fieldLabel");
            return this;
        }

        public Builder fieldName(FieldName fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder fieldValue(FieldValue fieldValue) {
            this.fieldValue = fieldValue;
            this.__explicitlySet__.add("fieldValue");
            return this;
        }

        public DocumentField build() {
            DocumentField model = new DocumentField(this.fieldType, this.fieldLabel, this.fieldName, this.fieldValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DocumentField model) {
            if (model.wasPropertyExplicitlySet("fieldType")) {
                this.fieldType(model.getFieldType());
            }
            if (model.wasPropertyExplicitlySet("fieldLabel")) {
                this.fieldLabel(model.getFieldLabel());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("fieldValue")) {
                this.fieldValue(model.getFieldValue());
            }
            return this;
        }
    }
}

