/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aidocument.AIServiceDocument;
import com.oracle.bmc.aidocument.AIServiceDocumentAsyncClient;
import com.oracle.bmc.aidocument.AIServiceDocumentWaiters;
import com.oracle.bmc.aidocument.model.ProcessorJob;
import com.oracle.bmc.aidocument.requests.CancelProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CreateProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.GetProcessorJobRequest;
import com.oracle.bmc.aidocument.responses.CancelProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CreateProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.GetProcessorJobResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceDocumentClient
extends BaseSyncClient
implements AIServiceDocument {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEDOCUMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://document.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceDocumentAsyncClient.class);
    private final AIServiceDocumentWaiters waiters;

    private AIServiceDocumentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AIServiceDocument-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AIServiceDocumentWaiters(executorService, this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelProcessorJobResponse cancelProcessorJob(CancelProcessorJobRequest request) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return (CancelProcessorJobResponse)this.clientCall(request, CancelProcessorJobResponse::builder).logger(LOG, "cancelProcessorJob").serviceDetails("AIServiceDocument", "CancelProcessorJob", "").method(Method.POST).requestBuilder(CancelProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelProcessorJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateProcessorJobResponse createProcessorJob(CreateProcessorJobRequest request) {
        Objects.requireNonNull(request.getCreateProcessorJobDetails(), "createProcessorJobDetails is required");
        return (CreateProcessorJobResponse)this.clientCall(request, CreateProcessorJobResponse::builder).logger(LOG, "createProcessorJob").serviceDetails("AIServiceDocument", "CreateProcessorJob", "").method(Method.POST).requestBuilder(CreateProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProcessorJob.class, CreateProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("opc-request-id", CreateProcessorJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateProcessorJobResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProcessorJobResponse getProcessorJob(GetProcessorJobRequest request) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return (GetProcessorJobResponse)this.clientCall(request, GetProcessorJobResponse::builder).logger(LOG, "getProcessorJob").serviceDetails("AIServiceDocument", "GetProcessorJob", "").method(Method.GET).requestBuilder(GetProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProcessorJob.class, GetProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("etag", GetProcessorJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProcessorJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AIServiceDocumentWaiters getWaiters() {
        return this.waiters;
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceDocumentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceDocumentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceDocumentClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AIServiceDocumentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceDocumentClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

