/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.responses;

import com.oracle.bmc.aianomalydetection.model.AnomalyDetectResult;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DetectAnomaliesResponse
extends BmcResponse {
    private String opcRequestId;
    private AnomalyDetectResult anomalyDetectResult;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AnomalyDetectResult getAnomalyDetectResult() {
        return this.anomalyDetectResult;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "anomalyDetectResult"})
    private DetectAnomaliesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, AnomalyDetectResult anomalyDetectResult) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.anomalyDetectResult = anomalyDetectResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",anomalyDetectResult=").append(String.valueOf((Object)this.anomalyDetectResult));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectAnomaliesResponse)) {
            return false;
        }
        DetectAnomaliesResponse other = (DetectAnomaliesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.anomalyDetectResult, (Object)other.anomalyDetectResult);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.anomalyDetectResult == null ? 43 : this.anomalyDetectResult.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<DetectAnomaliesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private AnomalyDetectResult anomalyDetectResult;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder anomalyDetectResult(AnomalyDetectResult anomalyDetectResult) {
            this.anomalyDetectResult = anomalyDetectResult;
            return this;
        }

        public Builder copy(DetectAnomaliesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.anomalyDetectResult(o.getAnomalyDetectResult());
            return this;
        }

        public DetectAnomaliesResponse build() {
            return new DetectAnomaliesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.anomalyDetectResult);
        }
    }
}

