/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.sasl;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.sasl.OciSaslClient;
import com.oracle.bmc.auth.sasl.OciSaslClientProvider;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;

abstract class OciLoginModule
implements LoginModule {
    private static final String INTENT_CONFIG = "intent";

    OciLoginModule() {
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String intent = (String)options.get(INTENT_CONFIG);
        if (intent == null) {
            throw new IllegalArgumentException("Intent is required.");
        }
        subject.getPublicCredentials().add(intent);
        BasicAuthenticationDetailsProvider authProvider = this.loadAuthenticationProvider(options);
        String cacheKey = OciSaslClient.AuthProviderCache.cache(authProvider);
        subject.getPrivateCredentials().add(cacheKey);
        subject.getPrivateCredentials().add(authProvider);
    }

    protected abstract BasicAuthenticationDetailsProvider loadAuthenticationProvider(Map<String, ?> var1);

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public boolean commit() {
        return true;
    }

    @Override
    public boolean abort() {
        return false;
    }

    @Override
    public boolean logout() {
        return true;
    }

    static {
        OciSaslClientProvider.initialize();
    }
}

