/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.graalvm;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.oracle.bmc.SdkClients;
import com.oracle.bmc.graalvm.SdkAutomaticFeatureMetadata;
import com.oracle.bmc.graalvm.SdkClientPackages;
import com.oracle.bmc.graalvm.utils.ReflectionUtils;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class SdkAutomaticFeature
implements Feature {
    SdkAutomaticFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        HashSet reflectiveAccess = new HashSet();
        SdkAutomaticFeature.populateReflectionData(reflectiveAccess, ResponseHelper.ErrorCodeAndMessage.class);
        String[] classes = SdkAutomaticFeature.resolveOracleCloudSdkClientNames(access).toArray(new String[0]);
        for (String aClass : classes) {
            Class c = access.findClassByName(aClass);
            if (c == null) continue;
            Set<Class> allInterfaces = ReflectionUtils.getAllInterfaces(c);
            for (Class i : allInterfaces) {
                if (i.getName().endsWith("Async")) continue;
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, i);
            }
        }
        for (Class clazz : reflectiveAccess) {
            boolean hasNoArgsConstructor = !clazz.isEnum() && !clazz.isInterface() && this.hasNoArgsConstructor(clazz.getDeclaredConstructors());
            RuntimeReflection.register((Class[])new Class[]{clazz});
            if (hasNoArgsConstructor) {
                RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
            }
            for (Method method : clazz.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
            if (clazz.isInterface()) continue;
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                RuntimeReflection.register((Field[])new Field[]{accessibleObject});
            }
        }
    }

    public static List<String> resolveOracleCloudSdkClientNames(Feature.BeforeAnalysisAccess access) {
        ArrayList<String> results = new ArrayList<String>();
        SdkClientPackages allSdkClientPackages = SdkAutomaticFeatureMetadata.class.getAnnotation(SdkClientPackages.class);
        for (String sdkClientsMetadataPath : allSdkClientPackages.value()) {
            Class[] allSdkClients;
            Class sdkClientsMetadataClass = access.findClassByName(sdkClientsMetadataPath);
            if (sdkClientsMetadataClass == null) continue;
            for (Class sdkClient : allSdkClients = sdkClientsMetadataClass.getDeclaredAnnotation(SdkClients.class).value()) {
                results.add(sdkClient.getName());
            }
        }
        return results;
    }

    private boolean hasNoArgsConstructor(Constructor<?>[] declaredConstructors) {
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            if (declaredConstructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        return hasNoArgsConstructor;
    }

    static void populateReflectionData(Set<Class<?>> reflectiveAccess, Class<?> type) {
        Method[] methods;
        JsonSubTypes.Type[] types;
        JsonSubTypes subTypes;
        Class di;
        JsonTypeInfo ti;
        Class builder;
        JsonDeserialize deser = type.getAnnotation(JsonDeserialize.class);
        if (deser != null && (builder = deser.builder()) != Void.class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, builder)) {
            reflectiveAccess.add(builder);
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, builder);
        }
        if ((ti = type.getAnnotation(JsonTypeInfo.class)) != null && (di = ti.defaultImpl()) != type && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, di)) {
            reflectiveAccess.add(di);
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, di);
        }
        if ((subTypes = type.getAnnotation(JsonSubTypes.class)) != null && (types = subTypes.value()) != null && types.length > 0) {
            for (Method method : types) {
                Class v = method.value();
                if (!SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, v)) continue;
                reflectiveAccess.add(v);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, v);
            }
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            Class<?> rt = method.getReturnType();
            if (Collection.class.isAssignableFrom(rt)) {
                Type arg;
                Type[] args;
                Type grt = method.getGenericReturnType();
                if (grt instanceof ParameterizedType && (args = ((ParameterizedType)grt).getActualTypeArguments()) != null && args.length == 1 && (arg = args[0]) instanceof Class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, arg)) {
                    Class t = (Class)arg;
                    reflectiveAccess.add(t);
                    SdkAutomaticFeature.populateReflectionData(reflectiveAccess, t);
                }
            } else if (SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, rt)) {
                reflectiveAccess.add(rt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, rt);
            }
            for (Class<?> pt : parameterTypes = method.getParameterTypes()) {
                if (!SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, pt)) continue;
                reflectiveAccess.add(pt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, pt);
            }
        }
    }

    static boolean includeInReflectiveData(Set<Class<?>> reflectiveAccess, Type rt) {
        return rt.getTypeName().startsWith("com.oracle.bmc") && !reflectiveAccess.contains(rt);
    }
}

