/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey.apacheconfigurator;

import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.ClientProperty;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.client.jersey.ApacheClientProperties;
import com.oracle.bmc.http.client.jersey.apacheconfigurator.ApacheConnectorProperties;
import com.oracle.bmc.util.JavaRuntimeUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLInitializationException;
import org.glassfish.jersey.SslConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheConfigurator
implements ClientConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheConfigurator.class);
    protected ApacheConnectorProperties apacheConnectorProperties;

    public ApacheConfigurator() {
        this.apacheConnectorProperties = ApacheConnectorProperties.builder().build();
    }

    public ApacheConfigurator(@Nonnull ApacheConnectorProperties apacheConnectorProperties) {
        if (apacheConnectorProperties == null) {
            throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
        }
        this.apacheConnectorProperties = apacheConnectorProperties;
    }

    public void customizeClient(HttpClientBuilder builder) {
        builder.property(StandardClientProperties.BUFFER_REQUEST, (Object)false);
        this.setApacheConnectorProperties(builder);
        this.setSslContext(builder);
    }

    protected void setSslContext(HttpClientBuilder builder) {
        JavaRuntimeUtils.JreVersion version = JavaRuntimeUtils.getRuntimeVersion();
        if (version == JavaRuntimeUtils.JreVersion.Java_7) {
            LOG.info("Running on 1.7 VM, manually setting security protocol to TLSv1.2");
            SSLContext sslContext = SslConfigurator.newInstance((boolean)true).securityProtocol("TLSv1.2").createSSLContext();
            builder.property(StandardClientProperties.SSL_CONTEXT, (Object)sslContext);
        } else if (version == JavaRuntimeUtils.JreVersion.Unsupported) {
            LOG.error("Using an unsupported runtime only 1.7+ is supported");
        } else if (version == JavaRuntimeUtils.JreVersion.Unknown) {
            LOG.warn("Using an unknown runtime, calls may not work");
        }
    }

    public ApacheConnectorProperties getApacheConnectorProperties() {
        return this.apacheConnectorProperties;
    }

    protected void setApacheConnectorProperties(HttpClientBuilder builder) {
        if (this.apacheConnectorProperties == null) {
            return;
        }
        if (this.apacheConnectorProperties.getConnectionManager() != null) {
            builder.property((ClientProperty)ApacheClientProperties.CONNECTION_MANAGER, (Object)this.apacheConnectorProperties.getConnectionManager());
        } else if (this.apacheConnectorProperties.isConnectionPooling()) {
            Registry<ConnectionSocketFactory> registry = this.getRegistry();
            Map.Entry<Integer, TimeUnit> ttl = this.apacheConnectorProperties.getConnectionPoolConfig().getTtl();
            PoolingHttpClientConnectionManager poolConnectionManager = registry != null ? (ttl != null ? new PoolingHttpClientConnectionManager(registry, null, null, null, (long)ttl.getKey().intValue(), ttl.getValue()) : new PoolingHttpClientConnectionManager(registry)) : (ttl != null ? new PoolingHttpClientConnectionManager((long)ttl.getKey().intValue(), ttl.getValue()) : new PoolingHttpClientConnectionManager());
            poolConnectionManager.setMaxTotal(this.apacheConnectorProperties.getConnectionPoolConfig().getTotalOpenConnections());
            poolConnectionManager.setDefaultMaxPerRoute(this.apacheConnectorProperties.getConnectionPoolConfig().getDefaultMaxConnectionsPerRoute());
            builder.property((ClientProperty)ApacheClientProperties.CONNECTION_MANAGER, (Object)poolConnectionManager);
        } else if (!this.apacheConnectorProperties.isConnectionPooling()) {
            BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager();
            builder.property((ClientProperty)ApacheClientProperties.CONNECTION_MANAGER, (Object)basicHttpClientConnectionManager);
        }
        if (this.apacheConnectorProperties.getKeepAliveStrategy() != null) {
            builder.property((ClientProperty)ApacheClientProperties.KEEPALIVE_STRATEGY, (Object)this.apacheConnectorProperties.getKeepAliveStrategy());
        }
        if (this.apacheConnectorProperties.getConnectionReuseStrategy() != null) {
            builder.property((ClientProperty)ApacheClientProperties.REUSE_STRATEGY, (Object)this.apacheConnectorProperties.getConnectionReuseStrategy());
        }
        if (this.apacheConnectorProperties.getConnectionClosingStrategy() != null) {
            builder.property((ClientProperty)ApacheClientProperties.CONNECTION_CLOSING_STRATEGY, (Object)this.apacheConnectorProperties.getConnectionClosingStrategy());
        }
        if (this.apacheConnectorProperties.getRequestRetryHandler() != null) {
            builder.property((ClientProperty)ApacheClientProperties.RETRY_HANDLER, (Object)this.apacheConnectorProperties.getRequestRetryHandler());
        }
        RequestConfig requestConfig = RequestConfig.custom().setContentCompressionEnabled(false).setExpectContinueEnabled(false).build();
        builder.property((ClientProperty)ApacheClientProperties.REQUEST_CONFIG, (Object)requestConfig);
        builder.property((ClientProperty)ApacheClientProperties.CONNECTION_MANAGER_SHARED, (Object)this.apacheConnectorProperties.isConnectionManagerShared());
    }

    private Registry<ConnectionSocketFactory> getRegistry() {
        Registry registry;
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        if (this.apacheConnectorProperties.getSslContext() != null) {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(this.apacheConnectorProperties.getSslContext(), this.apacheConnectorProperties.getHostnameVerifier());
        }
        try {
            registry = sslConnectionSocketFactory != null ? registryBuilder.register("https", sslConnectionSocketFactory).build() : registryBuilder.register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        }
        catch (SSLInitializationException e) {
            registry = registryBuilder.register("https", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
        return registry;
    }

    public static class NonBuffering
    extends ApacheConfigurator {
        public NonBuffering() {
        }

        public NonBuffering(@Nonnull ApacheConnectorProperties apacheConnectorProperties) {
            if (apacheConnectorProperties == null) {
                throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
            }
            this.apacheConnectorProperties = apacheConnectorProperties;
        }

        @Override
        public void customizeClient(HttpClientBuilder builder) {
            super.customizeClient(builder);
            builder.property(StandardClientProperties.BUFFER_REQUEST, (Object)false);
        }
    }
}

