/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.query.Criteria;
import com.oracle.nosql.spring.data.core.query.CriteriaQuery;
import com.oracle.nosql.spring.data.core.query.CriteriaType;
import com.oracle.nosql.spring.data.repository.ReactiveNosqlRepository;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveNosqlRepository<T, ID extends Serializable>
implements ReactiveNosqlRepository<T, ID> {
    private final NosqlEntityInformation<T, ID> entityInformation;
    private final ReactiveNosqlOperations nosqlOperations;

    public SimpleReactiveNosqlRepository(NosqlEntityInformation<T, ID> metadata, ApplicationContext applicationContext) {
        this.nosqlOperations = (ReactiveNosqlOperations)applicationContext.getBean(ReactiveNosqlOperations.class);
        this.entityInformation = metadata;
        this.createTableIfNotExists();
    }

    public SimpleReactiveNosqlRepository(NosqlEntityInformation<T, ID> metadata, ReactiveNosqlOperations reactiveNosqlOperations) {
        this.nosqlOperations = reactiveNosqlOperations;
        this.entityInformation = metadata;
        this.createTableIfNotExists();
    }

    private void createTableIfNotExists() {
        this.nosqlOperations.createTableIfNotExists(this.entityInformation).block();
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.nosqlOperations.insert(this.entityInformation, entity);
        }
        return this.nosqlOperations.update(this.entityInformation, entity);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.nosqlOperations.findById(this.entityInformation, id);
    }

    public Mono<T> findById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The given id must not be null!");
        return Mono.from(idPublisher).flatMap(id -> this.nosqlOperations.findById(this.entityInformation, id));
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.nosqlOperations.existsById(this.entityInformation, id);
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.nosqlOperations.existsById(this.entityInformation, id));
    }

    public Flux<T> findAll() {
        return this.nosqlOperations.findAll(this.entityInformation);
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(ids));
    }

    public Flux<T> findAllById(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"The given Publisher of Id's must not be null!");
        return this.nosqlOperations.findAllById(this.entityInformation, idStream);
    }

    public Mono<Long> count() {
        return this.nosqlOperations.count(this.entityInformation);
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.deleteById((Publisher<ID>)Mono.just(id));
    }

    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"Id must not be null!");
        return Mono.from(idPublisher).flatMap(id -> this.nosqlOperations.deleteById(this.entityInformation, id)).then();
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"entity to be deleted must not be null!");
        Serializable id = (Serializable)this.entityInformation.getId(entity);
        return this.nosqlOperations.deleteById(this.entityInformation, id);
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        return Flux.fromIterable(ids).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll() {
        return this.nosqlOperations.deleteAll(this.entityInformation);
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        CriteriaQuery query = new CriteriaQuery(Criteria.getInstance(CriteriaType.ALL), null).with(sort);
        return this.nosqlOperations.find(query, this.entityInformation);
    }

    @Override
    public int getTimeout() {
        return this.entityInformation.getTimeout();
    }

    @Override
    public void setTimeout(int milliseconds) {
        this.entityInformation.setTimeout(milliseconds);
    }

    @Override
    public String getConsistency() {
        return this.entityInformation.getConsistency().name();
    }

    @Override
    public void setConsistency(String consistency) {
        this.entityInformation.setConsistency(consistency);
    }
}

