/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.mapping.NosqlMappingContext;
import com.oracle.nosql.spring.data.repository.support.ReactiveNosqlRepositoryFactory;
import java.io.Serializable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class ReactiveNosqlRepositoryFactoryBean<T extends Repository<S, K>, S, K extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, K>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ReactiveNosqlOperations reactiveNosqlOperations;
    private boolean mappingContextConfigured = false;

    public ReactiveNosqlRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setReactiveNosqlOperations(ReactiveNosqlOperations operations) {
        this.reactiveNosqlOperations = operations;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.applicationContext);
    }

    protected RepositoryFactorySupport getFactoryInstance(ApplicationContext applicationContext) {
        return new ReactiveNosqlRepositoryFactory(this.reactiveNosqlOperations, applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.mappingContextConfigured) {
            if (this.reactiveNosqlOperations != null) {
                this.setMappingContext(this.reactiveNosqlOperations.getConverter().getMappingContext());
            } else {
                this.setMappingContext((MappingContext<?, ?>)new NosqlMappingContext());
            }
        }
    }
}

