/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.mapping.NosqlMappingContext;
import com.oracle.nosql.spring.data.repository.support.NosqlRepositoryFactory;
import java.io.Serializable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class NosqlRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private NosqlOperations operations;
    private boolean mappingContextConfigured = false;

    public NosqlRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setNosqlOperations(NosqlOperations nosqlOperations) {
        this.operations = nosqlOperations;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.applicationContext);
    }

    protected RepositoryFactorySupport getFactoryInstance(ApplicationContext applicationContext) {
        return new NosqlRepositoryFactory(this.operations, applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.mappingContextConfigured) {
            if (this.operations != null && this.operations.getConverter() != null) {
                this.setMappingContext(this.operations.getConverter().getMappingContext());
            } else {
                this.setMappingContext((MappingContext<?, ?>)new NosqlMappingContext());
            }
        }
    }
}

