/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.core.query.StringQuery;
import com.oracle.nosql.spring.data.repository.Query;
import com.oracle.nosql.spring.data.repository.query.AbstractNosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;

public class StringBasedNosqlQuery
extends AbstractNosqlQuery {
    private final String query;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final boolean isDeleteQuery;

    public StringBasedNosqlQuery(NosqlQueryMethod method, NosqlOperations dbOperations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, dbOperations, evaluationContextProvider);
    }

    public StringBasedNosqlQuery(String query, NosqlQueryMethod method, NosqlOperations dbOperations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, dbOperations);
        this.query = query;
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            this.isDeleteQuery = queryAnnotation.delete();
            if (StringBasedNosqlQuery.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery, this.isDeleteQuery)) {
                throw new IllegalArgumentException(String.format("Manually defined query for %s cannot be a count and exists or delete query at the same time!", new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
            this.isDeleteQuery = false;
        }
    }

    @Override
    protected NosqlQuery createQuery(NosqlParameterAccessor accessor) {
        return new StringQuery(this.getQueryMethod(), this.query, accessor);
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    private static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return StringBasedNosqlQuery.countBooleanTrueValues(isCountQuery, isExistsQuery, isDeleteQuery) > 1;
    }

    static int countBooleanTrueValues(boolean ... values) {
        int count = 0;
        for (boolean value : values) {
            if (!value) continue;
            ++count;
        }
        return count;
    }
}

