/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;

public interface ReactiveNosqlQueryExecution {
    public Object execute(NosqlQuery var1, Class<?> var2, String var3);

    public static final class DeleteExecution
    implements ReactiveNosqlQueryExecution {
        private final ReactiveNosqlOperations operations;
        private final NosqlEntityInformation<?, ?> entityInformation;

        public DeleteExecution(ReactiveNosqlOperations operations, NosqlEntityInformation<?, ?> entityInformation) {
            this.operations = operations;
            this.entityInformation = entityInformation;
        }

        @Override
        public Object execute(NosqlQuery query, Class<?> type, String collection) {
            return this.operations.delete(query, this.entityInformation);
        }
    }

    public static final class CountExecution
    implements ReactiveNosqlQueryExecution {
        private final ReactiveNosqlOperations operations;
        private final NosqlEntityInformation<?, ?> entityInformation;

        public CountExecution(ReactiveNosqlOperations operations, NosqlEntityInformation<?, ?> entityInformation) {
            this.operations = operations;
            this.entityInformation = entityInformation;
        }

        @Override
        public Object execute(NosqlQuery query, Class<?> type, String tableName) {
            return this.operations.count(query, this.entityInformation);
        }
    }

    public static final class ExistsExecution
    implements ReactiveNosqlQueryExecution {
        private final ReactiveNosqlOperations operations;
        private final NosqlEntityInformation<?, ?> entityInformation;

        public ExistsExecution(ReactiveNosqlOperations operations, NosqlEntityInformation<?, ?> entityInformation) {
            this.operations = operations;
            this.entityInformation = entityInformation;
        }

        @Override
        public Object execute(NosqlQuery query, Class<?> type, String tableName) {
            return this.operations.exists(query, this.entityInformation);
        }
    }

    public static final class MultiEntityExecution
    implements ReactiveNosqlQueryExecution {
        private final ReactiveNosqlOperations operations;
        private final NosqlEntityInformation<?, ?> entityInformation;

        public MultiEntityExecution(ReactiveNosqlOperations operations, NosqlEntityInformation<?, ?> entityInformation) {
            this.operations = operations;
            this.entityInformation = entityInformation;
        }

        @Override
        public Object execute(NosqlQuery query, Class<?> type, String tableName) {
            return this.operations.find(query, this.entityInformation);
        }
    }
}

