/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.AbstractReactiveNosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryCreator;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeReactiveNosqlQuery
extends AbstractReactiveNosqlQuery {
    private final PartTree tree;
    private final MappingContext<?, NosqlPersistentProperty> mappingContext;
    private final ResultProcessor processor;

    public PartTreeReactiveNosqlQuery(NosqlQueryMethod method, ReactiveNosqlOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    @Override
    protected NosqlQuery createQuery(NosqlParameterAccessor accessor) {
        NosqlQueryCreator creator = new NosqlQueryCreator(this.tree, accessor, this.mappingContext, this.processor.getReturnedType());
        NosqlQuery query = (NosqlQuery)creator.createQuery();
        if (this.tree.isLimiting()) {
            throw new NotImplementedException("Limiting is not supported.");
        }
        return query;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }
}

